/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a code security integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSecurityIntegrationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSecurityIntegrationSummary.Builder, CodeSecurityIntegrationSummary> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationArn").getter(getter(CodeSecurityIntegrationSummary::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CodeSecurityIntegrationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CodeSecurityIntegrationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CodeSecurityIntegrationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CodeSecurityIntegrationSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdOn").getter(getter(CodeSecurityIntegrationSummary::createdOn)).setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdOn").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateOn").getter(getter(CodeSecurityIntegrationSummary::lastUpdateOn))
            .setter(setter(Builder::lastUpdateOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateOn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CodeSecurityIntegrationSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD,
            NAME_FIELD, TYPE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATED_ON_FIELD, LAST_UPDATE_ON_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String integrationArn;

    private final String name;

    private final String type;

    private final String status;

    private final String statusReason;

    private final Instant createdOn;

    private final Instant lastUpdateOn;

    private final Map<String, String> tags;

    private CodeSecurityIntegrationSummary(BuilderImpl builder) {
        this.integrationArn = builder.integrationArn;
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdOn = builder.createdOn;
        this.lastUpdateOn = builder.lastUpdateOn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the code security integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the code security integration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The name of the code security integration.
     * </p>
     * 
     * @return The name of the code security integration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of repository provider for the integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of repository provider for the integration.
     * @see IntegrationType
     */
    public final IntegrationType type() {
        return IntegrationType.fromValue(type);
    }

    /**
     * <p>
     * The type of repository provider for the integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of repository provider for the integration.
     * @see IntegrationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The current status of the code security integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code security integration.
     * @see IntegrationStatus
     */
    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the code security integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code security integration.
     * @see IntegrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the code security integration.
     * </p>
     * 
     * @return The reason for the current status of the code security integration.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The timestamp when the code security integration was created.
     * </p>
     * 
     * @return The timestamp when the code security integration was created.
     */
    public final Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The timestamp when the code security integration was last updated.
     * </p>
     * 
     * @return The timestamp when the code security integration was last updated.
     */
    public final Instant lastUpdateOn() {
        return lastUpdateOn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the code security integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the code security integration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateOn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityIntegrationSummary)) {
            return false;
        }
        CodeSecurityIntegrationSummary other = (CodeSecurityIntegrationSummary) obj;
        return Objects.equals(integrationArn(), other.integrationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(createdOn(), other.createdOn())
                && Objects.equals(lastUpdateOn(), other.lastUpdateOn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSecurityIntegrationSummary").add("IntegrationArn", integrationArn()).add("Name", name())
                .add("Type", typeAsString()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("CreatedOn", createdOn()).add("LastUpdateOn", lastUpdateOn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "createdOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "lastUpdateOn":
            return Optional.ofNullable(clazz.cast(lastUpdateOn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("createdOn", CREATED_ON_FIELD);
        map.put("lastUpdateOn", LAST_UPDATE_ON_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityIntegrationSummary, T> g) {
        return obj -> g.apply((CodeSecurityIntegrationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSecurityIntegrationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the code security integration.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the code security integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The name of the code security integration.
         * </p>
         * 
         * @param name
         *        The name of the code security integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of repository provider for the integration.
         * </p>
         * 
         * @param type
         *        The type of repository provider for the integration.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of repository provider for the integration.
         * </p>
         * 
         * @param type
         *        The type of repository provider for the integration.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder type(IntegrationType type);

        /**
         * <p>
         * The current status of the code security integration.
         * </p>
         * 
         * @param status
         *        The current status of the code security integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the code security integration.
         * </p>
         * 
         * @param status
         *        The current status of the code security integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder status(IntegrationStatus status);

        /**
         * <p>
         * The reason for the current status of the code security integration.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current status of the code security integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The timestamp when the code security integration was created.
         * </p>
         * 
         * @param createdOn
         *        The timestamp when the code security integration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The timestamp when the code security integration was last updated.
         * </p>
         * 
         * @param lastUpdateOn
         *        The timestamp when the code security integration was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateOn(Instant lastUpdateOn);

        /**
         * <p>
         * The tags associated with the code security integration.
         * </p>
         * 
         * @param tags
         *        The tags associated with the code security integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String integrationArn;

        private String name;

        private String type;

        private String status;

        private String statusReason;

        private Instant createdOn;

        private Instant lastUpdateOn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityIntegrationSummary model) {
            integrationArn(model.integrationArn);
            name(model.name);
            type(model.type);
            status(model.status);
            statusReason(model.statusReason);
            createdOn(model.createdOn);
            lastUpdateOn(model.lastUpdateOn);
            tags(model.tags);
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastUpdateOn() {
            return lastUpdateOn;
        }

        public final void setLastUpdateOn(Instant lastUpdateOn) {
            this.lastUpdateOn = lastUpdateOn;
        }

        @Override
        public final Builder lastUpdateOn(Instant lastUpdateOn) {
            this.lastUpdateOn = lastUpdateOn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CodeSecurityIntegrationSummary build() {
            return new CodeSecurityIntegrationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
