/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration settings for code security scans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSecurityScanConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSecurityScanConfiguration.Builder, CodeSecurityScanConfiguration> {
    private static final SdkField<PeriodicScanConfiguration> PERIODIC_SCAN_CONFIGURATION_FIELD = SdkField
            .<PeriodicScanConfiguration> builder(MarshallingType.SDK_POJO).memberName("periodicScanConfiguration")
            .getter(getter(CodeSecurityScanConfiguration::periodicScanConfiguration))
            .setter(setter(Builder::periodicScanConfiguration)).constructor(PeriodicScanConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodicScanConfiguration").build())
            .build();

    private static final SdkField<ContinuousIntegrationScanConfiguration> CONTINUOUS_INTEGRATION_SCAN_CONFIGURATION_FIELD = SdkField
            .<ContinuousIntegrationScanConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("continuousIntegrationScanConfiguration")
            .getter(getter(CodeSecurityScanConfiguration::continuousIntegrationScanConfiguration))
            .setter(setter(Builder::continuousIntegrationScanConfiguration))
            .constructor(ContinuousIntegrationScanConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("continuousIntegrationScanConfiguration").build()).build();

    private static final SdkField<List<String>> RULE_SET_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ruleSetCategories")
            .getter(getter(CodeSecurityScanConfiguration::ruleSetCategoriesAsStrings))
            .setter(setter(Builder::ruleSetCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleSetCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERIODIC_SCAN_CONFIGURATION_FIELD, CONTINUOUS_INTEGRATION_SCAN_CONFIGURATION_FIELD, RULE_SET_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PeriodicScanConfiguration periodicScanConfiguration;

    private final ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration;

    private final List<String> ruleSetCategories;

    private CodeSecurityScanConfiguration(BuilderImpl builder) {
        this.periodicScanConfiguration = builder.periodicScanConfiguration;
        this.continuousIntegrationScanConfiguration = builder.continuousIntegrationScanConfiguration;
        this.ruleSetCategories = builder.ruleSetCategories;
    }

    /**
     * <p>
     * Configuration settings for periodic scans that run on a scheduled basis.
     * </p>
     * 
     * @return Configuration settings for periodic scans that run on a scheduled basis.
     */
    public final PeriodicScanConfiguration periodicScanConfiguration() {
        return periodicScanConfiguration;
    }

    /**
     * <p>
     * Configuration settings for continuous integration scans that run automatically when code changes are made.
     * </p>
     * 
     * @return Configuration settings for continuous integration scans that run automatically when code changes are
     *         made.
     */
    public final ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration() {
        return continuousIntegrationScanConfiguration;
    }

    /**
     * <p>
     * The categories of security rules to be applied during the scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetCategories} method.
     * </p>
     * 
     * @return The categories of security rules to be applied during the scan.
     */
    public final List<RuleSetCategory> ruleSetCategories() {
        return RuleSetCategoriesCopier.copyStringToEnum(ruleSetCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleSetCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleSetCategories() {
        return ruleSetCategories != null && !(ruleSetCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categories of security rules to be applied during the scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetCategories} method.
     * </p>
     * 
     * @return The categories of security rules to be applied during the scan.
     */
    public final List<String> ruleSetCategoriesAsStrings() {
        return ruleSetCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodicScanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(continuousIntegrationScanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleSetCategories() ? ruleSetCategoriesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityScanConfiguration)) {
            return false;
        }
        CodeSecurityScanConfiguration other = (CodeSecurityScanConfiguration) obj;
        return Objects.equals(periodicScanConfiguration(), other.periodicScanConfiguration())
                && Objects.equals(continuousIntegrationScanConfiguration(), other.continuousIntegrationScanConfiguration())
                && hasRuleSetCategories() == other.hasRuleSetCategories()
                && Objects.equals(ruleSetCategoriesAsStrings(), other.ruleSetCategoriesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSecurityScanConfiguration").add("PeriodicScanConfiguration", periodicScanConfiguration())
                .add("ContinuousIntegrationScanConfiguration", continuousIntegrationScanConfiguration())
                .add("RuleSetCategories", hasRuleSetCategories() ? ruleSetCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "periodicScanConfiguration":
            return Optional.ofNullable(clazz.cast(periodicScanConfiguration()));
        case "continuousIntegrationScanConfiguration":
            return Optional.ofNullable(clazz.cast(continuousIntegrationScanConfiguration()));
        case "ruleSetCategories":
            return Optional.ofNullable(clazz.cast(ruleSetCategoriesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("periodicScanConfiguration", PERIODIC_SCAN_CONFIGURATION_FIELD);
        map.put("continuousIntegrationScanConfiguration", CONTINUOUS_INTEGRATION_SCAN_CONFIGURATION_FIELD);
        map.put("ruleSetCategories", RULE_SET_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityScanConfiguration, T> g) {
        return obj -> g.apply((CodeSecurityScanConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSecurityScanConfiguration> {
        /**
         * <p>
         * Configuration settings for periodic scans that run on a scheduled basis.
         * </p>
         * 
         * @param periodicScanConfiguration
         *        Configuration settings for periodic scans that run on a scheduled basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodicScanConfiguration(PeriodicScanConfiguration periodicScanConfiguration);

        /**
         * <p>
         * Configuration settings for periodic scans that run on a scheduled basis.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeriodicScanConfiguration.Builder}
         * avoiding the need to create one manually via {@link PeriodicScanConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PeriodicScanConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #periodicScanConfiguration(PeriodicScanConfiguration)}.
         * 
         * @param periodicScanConfiguration
         *        a consumer that will call methods on {@link PeriodicScanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #periodicScanConfiguration(PeriodicScanConfiguration)
         */
        default Builder periodicScanConfiguration(Consumer<PeriodicScanConfiguration.Builder> periodicScanConfiguration) {
            return periodicScanConfiguration(PeriodicScanConfiguration.builder().applyMutation(periodicScanConfiguration).build());
        }

        /**
         * <p>
         * Configuration settings for continuous integration scans that run automatically when code changes are made.
         * </p>
         * 
         * @param continuousIntegrationScanConfiguration
         *        Configuration settings for continuous integration scans that run automatically when code changes are
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanConfiguration(
                ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration);

        /**
         * <p>
         * Configuration settings for continuous integration scans that run automatically when code changes are made.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContinuousIntegrationScanConfiguration.Builder} avoiding the need to create one manually via
         * {@link ContinuousIntegrationScanConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContinuousIntegrationScanConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfiguration)}.
         * 
         * @param continuousIntegrationScanConfiguration
         *        a consumer that will call methods on {@link ContinuousIntegrationScanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfiguration)
         */
        default Builder continuousIntegrationScanConfiguration(
                Consumer<ContinuousIntegrationScanConfiguration.Builder> continuousIntegrationScanConfiguration) {
            return continuousIntegrationScanConfiguration(ContinuousIntegrationScanConfiguration.builder()
                    .applyMutation(continuousIntegrationScanConfiguration).build());
        }

        /**
         * <p>
         * The categories of security rules to be applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules to be applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories);

        /**
         * <p>
         * The categories of security rules to be applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules to be applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategoriesWithStrings(String... ruleSetCategories);

        /**
         * <p>
         * The categories of security rules to be applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules to be applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories);

        /**
         * <p>
         * The categories of security rules to be applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules to be applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategories(RuleSetCategory... ruleSetCategories);
    }

    static final class BuilderImpl implements Builder {
        private PeriodicScanConfiguration periodicScanConfiguration;

        private ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration;

        private List<String> ruleSetCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityScanConfiguration model) {
            periodicScanConfiguration(model.periodicScanConfiguration);
            continuousIntegrationScanConfiguration(model.continuousIntegrationScanConfiguration);
            ruleSetCategoriesWithStrings(model.ruleSetCategories);
        }

        public final PeriodicScanConfiguration.Builder getPeriodicScanConfiguration() {
            return periodicScanConfiguration != null ? periodicScanConfiguration.toBuilder() : null;
        }

        public final void setPeriodicScanConfiguration(PeriodicScanConfiguration.BuilderImpl periodicScanConfiguration) {
            this.periodicScanConfiguration = periodicScanConfiguration != null ? periodicScanConfiguration.build() : null;
        }

        @Override
        public final Builder periodicScanConfiguration(PeriodicScanConfiguration periodicScanConfiguration) {
            this.periodicScanConfiguration = periodicScanConfiguration;
            return this;
        }

        public final ContinuousIntegrationScanConfiguration.Builder getContinuousIntegrationScanConfiguration() {
            return continuousIntegrationScanConfiguration != null ? continuousIntegrationScanConfiguration.toBuilder() : null;
        }

        public final void setContinuousIntegrationScanConfiguration(
                ContinuousIntegrationScanConfiguration.BuilderImpl continuousIntegrationScanConfiguration) {
            this.continuousIntegrationScanConfiguration = continuousIntegrationScanConfiguration != null ? continuousIntegrationScanConfiguration
                    .build() : null;
        }

        @Override
        public final Builder continuousIntegrationScanConfiguration(
                ContinuousIntegrationScanConfiguration continuousIntegrationScanConfiguration) {
            this.continuousIntegrationScanConfiguration = continuousIntegrationScanConfiguration;
            return this;
        }

        public final Collection<String> getRuleSetCategories() {
            if (ruleSetCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleSetCategories;
        }

        public final void setRuleSetCategories(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
        }

        @Override
        public final Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategoriesWithStrings(String... ruleSetCategories) {
            ruleSetCategoriesWithStrings(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public final Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copyEnumToString(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategories(RuleSetCategory... ruleSetCategories) {
            ruleSetCategories(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public CodeSecurityScanConfiguration build() {
            return new CodeSecurityScanConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
