/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of an association between a code repository and a scan configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSecurityScanConfigurationAssociationSummary
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<CodeSecurityScanConfigurationAssociationSummary.Builder, CodeSecurityScanConfigurationAssociationSummary> {
    private static final SdkField<CodeSecurityResource> RESOURCE_FIELD = SdkField
            .<CodeSecurityResource> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(CodeSecurityScanConfigurationAssociationSummary::resource)).setter(setter(Builder::resource))
            .constructor(CodeSecurityResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CodeSecurityResource resource;

    private CodeSecurityScanConfigurationAssociationSummary(BuilderImpl builder) {
        this.resource = builder.resource;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public final CodeSecurityResource resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityScanConfigurationAssociationSummary)) {
            return false;
        }
        CodeSecurityScanConfigurationAssociationSummary other = (CodeSecurityScanConfigurationAssociationSummary) obj;
        return Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSecurityScanConfigurationAssociationSummary").add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityScanConfigurationAssociationSummary, T> g) {
        return obj -> g.apply((CodeSecurityScanConfigurationAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSecurityScanConfigurationAssociationSummary> {
        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(CodeSecurityResource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodeSecurityResource.Builder} avoiding
         * the need to create one manually via {@link CodeSecurityResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeSecurityResource.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(CodeSecurityResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link CodeSecurityResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(CodeSecurityResource)
         */
        default Builder resource(Consumer<CodeSecurityResource.Builder> resource) {
            return resource(CodeSecurityResource.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeSecurityResource resource;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityScanConfigurationAssociationSummary model) {
            resource(model.resource);
        }

        public final CodeSecurityResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(CodeSecurityResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(CodeSecurityResource resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public CodeSecurityScanConfigurationAssociationSummary build() {
            return new CodeSecurityScanConfigurationAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
