/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on a code snippet retrieved by Amazon Inspector from a code vulnerability finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSnippetResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSnippetResult.Builder, CodeSnippetResult> {
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingArn").getter(getter(CodeSnippetResult::findingArn)).setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()).build();

    private static final SdkField<Integer> START_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startLine").getter(getter(CodeSnippetResult::startLine)).setter(setter(Builder::startLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startLine").build()).build();

    private static final SdkField<Integer> END_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endLine").getter(getter(CodeSnippetResult::endLine)).setter(setter(Builder::endLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endLine").build()).build();

    private static final SdkField<List<CodeLine>> CODE_SNIPPET_FIELD = SdkField
            .<List<CodeLine>> builder(MarshallingType.LIST)
            .memberName("codeSnippet")
            .getter(getter(CodeSnippetResult::codeSnippet))
            .setter(setter(Builder::codeSnippet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSnippet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeLine> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeLine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SuggestedFix>> SUGGESTED_FIXES_FIELD = SdkField
            .<List<SuggestedFix>> builder(MarshallingType.LIST)
            .memberName("suggestedFixes")
            .getter(getter(CodeSnippetResult::suggestedFixes))
            .setter(setter(Builder::suggestedFixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedFixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggestedFix> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggestedFix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARN_FIELD,
            START_LINE_FIELD, END_LINE_FIELD, CODE_SNIPPET_FIELD, SUGGESTED_FIXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String findingArn;

    private final Integer startLine;

    private final Integer endLine;

    private final List<CodeLine> codeSnippet;

    private final List<SuggestedFix> suggestedFixes;

    private CodeSnippetResult(BuilderImpl builder) {
        this.findingArn = builder.findingArn;
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.codeSnippet = builder.codeSnippet;
        this.suggestedFixes = builder.suggestedFixes;
    }

    /**
     * <p>
     * The ARN of a finding that the code snippet is associated with.
     * </p>
     * 
     * @return The ARN of a finding that the code snippet is associated with.
     */
    public final String findingArn() {
        return findingArn;
    }

    /**
     * <p>
     * The line number of the first line of a code snippet.
     * </p>
     * 
     * @return The line number of the first line of a code snippet.
     */
    public final Integer startLine() {
        return startLine;
    }

    /**
     * <p>
     * The line number of the last line of a code snippet.
     * </p>
     * 
     * @return The line number of the last line of a code snippet.
     */
    public final Integer endLine() {
        return endLine;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeSnippet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCodeSnippet() {
        return codeSnippet != null && !(codeSnippet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information on the retrieved code snippet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeSnippet} method.
     * </p>
     * 
     * @return Contains information on the retrieved code snippet.
     */
    public final List<CodeLine> codeSnippet() {
        return codeSnippet;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestedFixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestedFixes() {
        return suggestedFixes != null && !(suggestedFixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of a suggested code fix.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestedFixes} method.
     * </p>
     * 
     * @return Details of a suggested code fix.
     */
    public final List<SuggestedFix> suggestedFixes() {
        return suggestedFixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(startLine());
        hashCode = 31 * hashCode + Objects.hashCode(endLine());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeSnippet() ? codeSnippet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestedFixes() ? suggestedFixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSnippetResult)) {
            return false;
        }
        CodeSnippetResult other = (CodeSnippetResult) obj;
        return Objects.equals(findingArn(), other.findingArn()) && Objects.equals(startLine(), other.startLine())
                && Objects.equals(endLine(), other.endLine()) && hasCodeSnippet() == other.hasCodeSnippet()
                && Objects.equals(codeSnippet(), other.codeSnippet()) && hasSuggestedFixes() == other.hasSuggestedFixes()
                && Objects.equals(suggestedFixes(), other.suggestedFixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSnippetResult").add("FindingArn", findingArn()).add("StartLine", startLine())
                .add("EndLine", endLine()).add("CodeSnippet", hasCodeSnippet() ? codeSnippet() : null)
                .add("SuggestedFixes", hasSuggestedFixes() ? suggestedFixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        case "startLine":
            return Optional.ofNullable(clazz.cast(startLine()));
        case "endLine":
            return Optional.ofNullable(clazz.cast(endLine()));
        case "codeSnippet":
            return Optional.ofNullable(clazz.cast(codeSnippet()));
        case "suggestedFixes":
            return Optional.ofNullable(clazz.cast(suggestedFixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("startLine", START_LINE_FIELD);
        map.put("endLine", END_LINE_FIELD);
        map.put("codeSnippet", CODE_SNIPPET_FIELD);
        map.put("suggestedFixes", SUGGESTED_FIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSnippetResult, T> g) {
        return obj -> g.apply((CodeSnippetResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSnippetResult> {
        /**
         * <p>
         * The ARN of a finding that the code snippet is associated with.
         * </p>
         * 
         * @param findingArn
         *        The ARN of a finding that the code snippet is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(String findingArn);

        /**
         * <p>
         * The line number of the first line of a code snippet.
         * </p>
         * 
         * @param startLine
         *        The line number of the first line of a code snippet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLine(Integer startLine);

        /**
         * <p>
         * The line number of the last line of a code snippet.
         * </p>
         * 
         * @param endLine
         *        The line number of the last line of a code snippet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endLine(Integer endLine);

        /**
         * <p>
         * Contains information on the retrieved code snippet.
         * </p>
         * 
         * @param codeSnippet
         *        Contains information on the retrieved code snippet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSnippet(Collection<CodeLine> codeSnippet);

        /**
         * <p>
         * Contains information on the retrieved code snippet.
         * </p>
         * 
         * @param codeSnippet
         *        Contains information on the retrieved code snippet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSnippet(CodeLine... codeSnippet);

        /**
         * <p>
         * Contains information on the retrieved code snippet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CodeLine.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.CodeLine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CodeLine.Builder#build()} is called immediately and
         * its result is passed to {@link #codeSnippet(List<CodeLine>)}.
         * 
         * @param codeSnippet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CodeLine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSnippet(java.util.Collection<CodeLine>)
         */
        Builder codeSnippet(Consumer<CodeLine.Builder>... codeSnippet);

        /**
         * <p>
         * Details of a suggested code fix.
         * </p>
         * 
         * @param suggestedFixes
         *        Details of a suggested code fix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedFixes(Collection<SuggestedFix> suggestedFixes);

        /**
         * <p>
         * Details of a suggested code fix.
         * </p>
         * 
         * @param suggestedFixes
         *        Details of a suggested code fix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedFixes(SuggestedFix... suggestedFixes);

        /**
         * <p>
         * Details of a suggested code fix.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.SuggestedFix.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.SuggestedFix#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.SuggestedFix.Builder#build()} is called immediately
         * and its result is passed to {@link #suggestedFixes(List<SuggestedFix>)}.
         * 
         * @param suggestedFixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.SuggestedFix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestedFixes(java.util.Collection<SuggestedFix>)
         */
        Builder suggestedFixes(Consumer<SuggestedFix.Builder>... suggestedFixes);
    }

    static final class BuilderImpl implements Builder {
        private String findingArn;

        private Integer startLine;

        private Integer endLine;

        private List<CodeLine> codeSnippet = DefaultSdkAutoConstructList.getInstance();

        private List<SuggestedFix> suggestedFixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSnippetResult model) {
            findingArn(model.findingArn);
            startLine(model.startLine);
            endLine(model.endLine);
            codeSnippet(model.codeSnippet);
            suggestedFixes(model.suggestedFixes);
        }

        public final String getFindingArn() {
            return findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Integer getStartLine() {
            return startLine;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public final Integer getEndLine() {
            return endLine;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final List<CodeLine.Builder> getCodeSnippet() {
            List<CodeLine.Builder> result = CodeLineListCopier.copyToBuilder(this.codeSnippet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeSnippet(Collection<CodeLine.BuilderImpl> codeSnippet) {
            this.codeSnippet = CodeLineListCopier.copyFromBuilder(codeSnippet);
        }

        @Override
        public final Builder codeSnippet(Collection<CodeLine> codeSnippet) {
            this.codeSnippet = CodeLineListCopier.copy(codeSnippet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippet(CodeLine... codeSnippet) {
            codeSnippet(Arrays.asList(codeSnippet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippet(Consumer<CodeLine.Builder>... codeSnippet) {
            codeSnippet(Stream.of(codeSnippet).map(c -> CodeLine.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SuggestedFix.Builder> getSuggestedFixes() {
            List<SuggestedFix.Builder> result = SuggestedFixesCopier.copyToBuilder(this.suggestedFixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestedFixes(Collection<SuggestedFix.BuilderImpl> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copyFromBuilder(suggestedFixes);
        }

        @Override
        public final Builder suggestedFixes(Collection<SuggestedFix> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copy(suggestedFixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(SuggestedFix... suggestedFixes) {
            suggestedFixes(Arrays.asList(suggestedFixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(Consumer<SuggestedFix.Builder>... suggestedFixes) {
            suggestedFixes(Stream.of(suggestedFixes).map(c -> SuggestedFix.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CodeSnippetResult build() {
            return new CodeSnippetResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
