/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the code vulnerability identified in your Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeVulnerabilityDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeVulnerabilityDetails.Builder, CodeVulnerabilityDetails> {
    private static final SdkField<CodeFilePath> FILE_PATH_FIELD = SdkField.<CodeFilePath> builder(MarshallingType.SDK_POJO)
            .memberName("filePath").getter(getter(CodeVulnerabilityDetails::filePath)).setter(setter(Builder::filePath))
            .constructor(CodeFilePath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<List<String>> DETECTOR_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("detectorTags")
            .getter(getter(CodeVulnerabilityDetails::detectorTags))
            .setter(setter(Builder::detectorTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("referenceUrls")
            .getter(getter(CodeVulnerabilityDetails::referenceUrls))
            .setter(setter(Builder::referenceUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(CodeVulnerabilityDetails::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<String> SOURCE_LAMBDA_LAYER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceLambdaLayerArn").getter(getter(CodeVulnerabilityDetails::sourceLambdaLayerArn))
            .setter(setter(Builder::sourceLambdaLayerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLambdaLayerArn").build())
            .build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(CodeVulnerabilityDetails::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorName").getter(getter(CodeVulnerabilityDetails::detectorName))
            .setter(setter(Builder::detectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()).build();

    private static final SdkField<List<String>> CWES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cwes")
            .getter(getter(CodeVulnerabilityDetails::cwes))
            .setter(setter(Builder::cwes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cwes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            DETECTOR_TAGS_FIELD, REFERENCE_URLS_FIELD, RULE_ID_FIELD, SOURCE_LAMBDA_LAYER_ARN_FIELD, DETECTOR_ID_FIELD,
            DETECTOR_NAME_FIELD, CWES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CodeFilePath filePath;

    private final List<String> detectorTags;

    private final List<String> referenceUrls;

    private final String ruleId;

    private final String sourceLambdaLayerArn;

    private final String detectorId;

    private final String detectorName;

    private final List<String> cwes;

    private CodeVulnerabilityDetails(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.detectorTags = builder.detectorTags;
        this.referenceUrls = builder.referenceUrls;
        this.ruleId = builder.ruleId;
        this.sourceLambdaLayerArn = builder.sourceLambdaLayerArn;
        this.detectorId = builder.detectorId;
        this.detectorName = builder.detectorName;
        this.cwes = builder.cwes;
    }

    /**
     * <p>
     * Contains information on where the code vulnerability is located in your code.
     * </p>
     * 
     * @return Contains information on where the code vulnerability is located in your code.
     */
    public final CodeFilePath filePath() {
        return filePath;
    }

    /**
     * For responses, this returns true if the service returned a value for the DetectorTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDetectorTags() {
        return detectorTags != null && !(detectorTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes
     * or tactics. For a list of available tags by programming language, see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetectorTags} method.
     * </p>
     * 
     * @return The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
     *         themes or tactics. For a list of available tags by programming language, see <a
     *         href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
     *         href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
     */
    public final List<String> detectorTags() {
        return detectorTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceUrls() {
        return referenceUrls != null && !(referenceUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A URL containing supporting documentation about the code vulnerability detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceUrls} method.
     * </p>
     * 
     * @return A URL containing supporting documentation about the code vulnerability detected.
     */
    public final List<String> referenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * The identifier for a rule that was used to detect the code vulnerability.
     * </p>
     * 
     * @return The identifier for a rule that was used to detect the code vulnerability.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     */
    public final String sourceLambdaLayerArn() {
        return sourceLambdaLayerArn;
    }

    /**
     * <p>
     * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     * </p>
     * 
     * @return The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors
     *         see <a href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The name of the detector used to identify the code vulnerability. For more information on detectors see <a
     * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     * </p>
     * 
     * @return The name of the detector used to identify the code vulnerability. For more information on detectors see
     *         <a href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
     */
    public final String detectorName() {
        return detectorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cwes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCwes() {
        return cwes != null && !(cwes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCwes} method.
     * </p>
     * 
     * @return The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     */
    public final List<String> cwes() {
        return cwes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectorTags() ? detectorTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceUrls() ? referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLambdaLayerArn());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCwes() ? cwes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeVulnerabilityDetails)) {
            return false;
        }
        CodeVulnerabilityDetails other = (CodeVulnerabilityDetails) obj;
        return Objects.equals(filePath(), other.filePath()) && hasDetectorTags() == other.hasDetectorTags()
                && Objects.equals(detectorTags(), other.detectorTags()) && hasReferenceUrls() == other.hasReferenceUrls()
                && Objects.equals(referenceUrls(), other.referenceUrls()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(sourceLambdaLayerArn(), other.sourceLambdaLayerArn())
                && Objects.equals(detectorId(), other.detectorId()) && Objects.equals(detectorName(), other.detectorName())
                && hasCwes() == other.hasCwes() && Objects.equals(cwes(), other.cwes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeVulnerabilityDetails").add("FilePath", filePath())
                .add("DetectorTags", hasDetectorTags() ? detectorTags() : null)
                .add("ReferenceUrls", hasReferenceUrls() ? referenceUrls() : null).add("RuleId", ruleId())
                .add("SourceLambdaLayerArn", sourceLambdaLayerArn()).add("DetectorId", detectorId())
                .add("DetectorName", detectorName()).add("Cwes", hasCwes() ? cwes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "detectorTags":
            return Optional.ofNullable(clazz.cast(detectorTags()));
        case "referenceUrls":
            return Optional.ofNullable(clazz.cast(referenceUrls()));
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "sourceLambdaLayerArn":
            return Optional.ofNullable(clazz.cast(sourceLambdaLayerArn()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorName":
            return Optional.ofNullable(clazz.cast(detectorName()));
        case "cwes":
            return Optional.ofNullable(clazz.cast(cwes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filePath", FILE_PATH_FIELD);
        map.put("detectorTags", DETECTOR_TAGS_FIELD);
        map.put("referenceUrls", REFERENCE_URLS_FIELD);
        map.put("ruleId", RULE_ID_FIELD);
        map.put("sourceLambdaLayerArn", SOURCE_LAMBDA_LAYER_ARN_FIELD);
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("detectorName", DETECTOR_NAME_FIELD);
        map.put("cwes", CWES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeVulnerabilityDetails, T> g) {
        return obj -> g.apply((CodeVulnerabilityDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeVulnerabilityDetails> {
        /**
         * <p>
         * Contains information on where the code vulnerability is located in your code.
         * </p>
         * 
         * @param filePath
         *        Contains information on where the code vulnerability is located in your code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(CodeFilePath filePath);

        /**
         * <p>
         * Contains information on where the code vulnerability is located in your code.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeFilePath.Builder} avoiding the need
         * to create one manually via {@link CodeFilePath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeFilePath.Builder#build()} is called immediately and its
         * result is passed to {@link #filePath(CodeFilePath)}.
         * 
         * @param filePath
         *        a consumer that will call methods on {@link CodeFilePath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filePath(CodeFilePath)
         */
        default Builder filePath(Consumer<CodeFilePath.Builder> filePath) {
            return filePath(CodeFilePath.builder().applyMutation(filePath).build());
        }

        /**
         * <p>
         * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
         * themes or tactics. For a list of available tags by programming language, see <a
         * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
         * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
         * </p>
         * 
         * @param detectorTags
         *        The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by
         *        common themes or tactics. For a list of available tags by programming language, see <a
         *        href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
         *        href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorTags(Collection<String> detectorTags);

        /**
         * <p>
         * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common
         * themes or tactics. For a list of available tags by programming language, see <a
         * href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
         * href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
         * </p>
         * 
         * @param detectorTags
         *        The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by
         *        common themes or tactics. For a list of available tags by programming language, see <a
         *        href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a
         *        href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorTags(String... detectorTags);

        /**
         * <p>
         * A URL containing supporting documentation about the code vulnerability detected.
         * </p>
         * 
         * @param referenceUrls
         *        A URL containing supporting documentation about the code vulnerability detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(Collection<String> referenceUrls);

        /**
         * <p>
         * A URL containing supporting documentation about the code vulnerability detected.
         * </p>
         * 
         * @param referenceUrls
         *        A URL containing supporting documentation about the code vulnerability detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(String... referenceUrls);

        /**
         * <p>
         * The identifier for a rule that was used to detect the code vulnerability.
         * </p>
         * 
         * @param ruleId
         *        The identifier for a rule that was used to detect the code vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
         * </p>
         * 
         * @param sourceLambdaLayerArn
         *        The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLambdaLayerArn(String sourceLambdaLayerArn);

        /**
         * <p>
         * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a
         * href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.
         * </p>
         * 
         * @param detectorId
         *        The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors
         *        see <a href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector
         *        Library</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The name of the detector used to identify the code vulnerability. For more information on detectors see <a
         * href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
         * </p>
         * 
         * @param detectorName
         *        The name of the detector used to identify the code vulnerability. For more information on detectors
         *        see <a href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorName(String detectorName);

        /**
         * <p>
         * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
         * </p>
         * 
         * @param cwes
         *        The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwes(Collection<String> cwes);

        /**
         * <p>
         * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
         * </p>
         * 
         * @param cwes
         *        The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwes(String... cwes);
    }

    static final class BuilderImpl implements Builder {
        private CodeFilePath filePath;

        private List<String> detectorTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();

        private String ruleId;

        private String sourceLambdaLayerArn;

        private String detectorId;

        private String detectorName;

        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeVulnerabilityDetails model) {
            filePath(model.filePath);
            detectorTags(model.detectorTags);
            referenceUrls(model.referenceUrls);
            ruleId(model.ruleId);
            sourceLambdaLayerArn(model.sourceLambdaLayerArn);
            detectorId(model.detectorId);
            detectorName(model.detectorName);
            cwes(model.cwes);
        }

        public final CodeFilePath.Builder getFilePath() {
            return filePath != null ? filePath.toBuilder() : null;
        }

        public final void setFilePath(CodeFilePath.BuilderImpl filePath) {
            this.filePath = filePath != null ? filePath.build() : null;
        }

        @Override
        public final Builder filePath(CodeFilePath filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Collection<String> getDetectorTags() {
            if (detectorTags instanceof SdkAutoConstructList) {
                return null;
            }
            return detectorTags;
        }

        public final void setDetectorTags(Collection<String> detectorTags) {
            this.detectorTags = DetectorTagListCopier.copy(detectorTags);
        }

        @Override
        public final Builder detectorTags(Collection<String> detectorTags) {
            this.detectorTags = DetectorTagListCopier.copy(detectorTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorTags(String... detectorTags) {
            detectorTags(Arrays.asList(detectorTags));
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String... referenceUrls) {
            referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getSourceLambdaLayerArn() {
            return sourceLambdaLayerArn;
        }

        public final void setSourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
        }

        @Override
        public final Builder sourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorName() {
            return detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final Collection<String> getCwes() {
            if (cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = CweListCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = CweListCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String... cwes) {
            cwes(Arrays.asList(cwes));
            return this;
        }

        @Override
        public CodeVulnerabilityDetails build() {
            return new CodeVulnerabilityDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
