/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for continuous integration scans that run automatically when code changes are made.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousIntegrationScanConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousIntegrationScanConfiguration.Builder, ContinuousIntegrationScanConfiguration> {
    private static final SdkField<List<String>> SUPPORTED_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedEvents")
            .getter(getter(ContinuousIntegrationScanConfiguration::supportedEventsAsStrings))
            .setter(setter(Builder::supportedEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> supportedEvents;

    private ContinuousIntegrationScanConfiguration(BuilderImpl builder) {
        this.supportedEvents = builder.supportedEvents;
    }

    /**
     * <p>
     * The repository events that trigger continuous integration scans, such as pull requests or commits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEvents} method.
     * </p>
     * 
     * @return The repository events that trigger continuous integration scans, such as pull requests or commits.
     */
    public final List<ContinuousIntegrationScanEvent> supportedEvents() {
        return ContinuousIntegrationScanSupportedEventsCopier.copyStringToEnum(supportedEvents);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedEvents() {
        return supportedEvents != null && !(supportedEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository events that trigger continuous integration scans, such as pull requests or commits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEvents} method.
     * </p>
     * 
     * @return The repository events that trigger continuous integration scans, such as pull requests or commits.
     */
    public final List<String> supportedEventsAsStrings() {
        return supportedEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedEvents() ? supportedEventsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousIntegrationScanConfiguration)) {
            return false;
        }
        ContinuousIntegrationScanConfiguration other = (ContinuousIntegrationScanConfiguration) obj;
        return hasSupportedEvents() == other.hasSupportedEvents()
                && Objects.equals(supportedEventsAsStrings(), other.supportedEventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousIntegrationScanConfiguration")
                .add("SupportedEvents", hasSupportedEvents() ? supportedEventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "supportedEvents":
            return Optional.ofNullable(clazz.cast(supportedEventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("supportedEvents", SUPPORTED_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousIntegrationScanConfiguration, T> g) {
        return obj -> g.apply((ContinuousIntegrationScanConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousIntegrationScanConfiguration> {
        /**
         * <p>
         * The repository events that trigger continuous integration scans, such as pull requests or commits.
         * </p>
         * 
         * @param supportedEvents
         *        The repository events that trigger continuous integration scans, such as pull requests or commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEventsWithStrings(Collection<String> supportedEvents);

        /**
         * <p>
         * The repository events that trigger continuous integration scans, such as pull requests or commits.
         * </p>
         * 
         * @param supportedEvents
         *        The repository events that trigger continuous integration scans, such as pull requests or commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEventsWithStrings(String... supportedEvents);

        /**
         * <p>
         * The repository events that trigger continuous integration scans, such as pull requests or commits.
         * </p>
         * 
         * @param supportedEvents
         *        The repository events that trigger continuous integration scans, such as pull requests or commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEvents(Collection<ContinuousIntegrationScanEvent> supportedEvents);

        /**
         * <p>
         * The repository events that trigger continuous integration scans, such as pull requests or commits.
         * </p>
         * 
         * @param supportedEvents
         *        The repository events that trigger continuous integration scans, such as pull requests or commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEvents(ContinuousIntegrationScanEvent... supportedEvents);
    }

    static final class BuilderImpl implements Builder {
        private List<String> supportedEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousIntegrationScanConfiguration model) {
            supportedEventsWithStrings(model.supportedEvents);
        }

        public final Collection<String> getSupportedEvents() {
            if (supportedEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedEvents;
        }

        public final void setSupportedEvents(Collection<String> supportedEvents) {
            this.supportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copy(supportedEvents);
        }

        @Override
        public final Builder supportedEventsWithStrings(Collection<String> supportedEvents) {
            this.supportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copy(supportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEventsWithStrings(String... supportedEvents) {
            supportedEventsWithStrings(Arrays.asList(supportedEvents));
            return this;
        }

        @Override
        public final Builder supportedEvents(Collection<ContinuousIntegrationScanEvent> supportedEvents) {
            this.supportedEvents = ContinuousIntegrationScanSupportedEventsCopier.copyEnumToString(supportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEvents(ContinuousIntegrationScanEvent... supportedEvents) {
            supportedEvents(Arrays.asList(supportedEvents));
            return this;
        }

        @Override
        public ContinuousIntegrationScanConfiguration build() {
            return new ContinuousIntegrationScanConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
