/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CoverageNumberFilterListCopier {
    static List<CoverageNumberFilter> copy(Collection<? extends CoverageNumberFilter> coverageNumberFilterListParam) {
        List<CoverageNumberFilter> list;
        if (coverageNumberFilterListParam == null || coverageNumberFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CoverageNumberFilter> modifiableList = new ArrayList<>(coverageNumberFilterListParam.size());
            coverageNumberFilterListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CoverageNumberFilter> copyFromBuilder(
            Collection<? extends CoverageNumberFilter.Builder> coverageNumberFilterListParam) {
        List<CoverageNumberFilter> list;
        if (coverageNumberFilterListParam == null || coverageNumberFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CoverageNumberFilter> modifiableList = new ArrayList<>(coverageNumberFilterListParam.size());
            coverageNumberFilterListParam.forEach(entry -> {
                CoverageNumberFilter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CoverageNumberFilter.Builder> copyToBuilder(
            Collection<? extends CoverageNumberFilter> coverageNumberFilterListParam) {
        List<CoverageNumberFilter.Builder> list;
        if (coverageNumberFilterListParam == null || coverageNumberFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CoverageNumberFilter.Builder> modifiableList = new ArrayList<>(coverageNumberFilterListParam.size());
            coverageNumberFilterListParam.forEach(entry -> {
                CoverageNumberFilter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
