/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCodeSecurityIntegrationRequest extends Inspector2Request implements
        ToCopyableBuilder<CreateCodeSecurityIntegrationRequest.Builder, CreateCodeSecurityIntegrationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCodeSecurityIntegrationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateCodeSecurityIntegrationRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<CreateIntegrationDetail> DETAILS_FIELD = SdkField
            .<CreateIntegrationDetail> builder(MarshallingType.SDK_POJO).memberName("details")
            .getter(getter(CreateCodeSecurityIntegrationRequest::details)).setter(setter(Builder::details))
            .constructor(CreateIntegrationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCodeSecurityIntegrationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            DETAILS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String type;

    private final CreateIntegrationDetail details;

    private final Map<String, String> tags;

    private CreateCodeSecurityIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.details = builder.details;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the code security integration.
     * </p>
     * 
     * @return The name of the code security integration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of repository provider for the integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of repository provider for the integration.
     * @see IntegrationType
     */
    public final IntegrationType type() {
        return IntegrationType.fromValue(type);
    }

    /**
     * <p>
     * The type of repository provider for the integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IntegrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of repository provider for the integration.
     * @see IntegrationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The integration details specific to the repository provider type.
     * </p>
     * 
     * @return The integration details specific to the repository provider type.
     */
    public final CreateIntegrationDetail details() {
        return details;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the code security integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the code security integration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeSecurityIntegrationRequest)) {
            return false;
        }
        CreateCodeSecurityIntegrationRequest other = (CreateCodeSecurityIntegrationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(details(), other.details()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCodeSecurityIntegrationRequest").add("Name", name()).add("Type", typeAsString())
                .add("Details", details()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeSecurityIntegrationRequest, T> g) {
        return obj -> g.apply((CreateCodeSecurityIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCodeSecurityIntegrationRequest> {
        /**
         * <p>
         * The name of the code security integration.
         * </p>
         * 
         * @param name
         *        The name of the code security integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of repository provider for the integration.
         * </p>
         * 
         * @param type
         *        The type of repository provider for the integration.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of repository provider for the integration.
         * </p>
         * 
         * @param type
         *        The type of repository provider for the integration.
         * @see IntegrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationType
         */
        Builder type(IntegrationType type);

        /**
         * <p>
         * The integration details specific to the repository provider type.
         * </p>
         * 
         * @param details
         *        The integration details specific to the repository provider type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(CreateIntegrationDetail details);

        /**
         * <p>
         * The integration details specific to the repository provider type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateIntegrationDetail.Builder} avoiding
         * the need to create one manually via {@link CreateIntegrationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateIntegrationDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #details(CreateIntegrationDetail)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link CreateIntegrationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(CreateIntegrationDetail)
         */
        default Builder details(Consumer<CreateIntegrationDetail.Builder> details) {
            return details(CreateIntegrationDetail.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The tags to apply to the code security integration.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the code security integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String name;

        private String type;

        private CreateIntegrationDetail details;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeSecurityIntegrationRequest model) {
            super(model);
            name(model.name);
            type(model.type);
            details(model.details);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CreateIntegrationDetail.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(CreateIntegrationDetail.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(CreateIntegrationDetail details) {
            this.details = details;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeSecurityIntegrationRequest build() {
            return new CreateCodeSecurityIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
