/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details required to create an integration with a self-managed GitLab instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGitLabSelfManagedIntegrationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateGitLabSelfManagedIntegrationDetail.Builder, CreateGitLabSelfManagedIntegrationDetail> {
    private static final SdkField<String> INSTANCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceUrl").getter(getter(CreateGitLabSelfManagedIntegrationDetail::instanceUrl))
            .setter(setter(Builder::instanceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceUrl").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(CreateGitLabSelfManagedIntegrationDetail::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_URL_FIELD,
            ACCESS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceUrl;

    private final String accessToken;

    private CreateGitLabSelfManagedIntegrationDetail(BuilderImpl builder) {
        this.instanceUrl = builder.instanceUrl;
        this.accessToken = builder.accessToken;
    }

    /**
     * <p>
     * The URL of the self-managed GitLab instance.
     * </p>
     * 
     * @return The URL of the self-managed GitLab instance.
     */
    public final String instanceUrl() {
        return instanceUrl;
    }

    /**
     * <p>
     * The personal access token used to authenticate with the self-managed GitLab instance.
     * </p>
     * 
     * @return The personal access token used to authenticate with the self-managed GitLab instance.
     */
    public final String accessToken() {
        return accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGitLabSelfManagedIntegrationDetail)) {
            return false;
        }
        CreateGitLabSelfManagedIntegrationDetail other = (CreateGitLabSelfManagedIntegrationDetail) obj;
        return Objects.equals(instanceUrl(), other.instanceUrl()) && Objects.equals(accessToken(), other.accessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGitLabSelfManagedIntegrationDetail")
                .add("InstanceUrl", instanceUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceUrl":
            return Optional.ofNullable(clazz.cast(instanceUrl()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceUrl", INSTANCE_URL_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGitLabSelfManagedIntegrationDetail, T> g) {
        return obj -> g.apply((CreateGitLabSelfManagedIntegrationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateGitLabSelfManagedIntegrationDetail> {
        /**
         * <p>
         * The URL of the self-managed GitLab instance.
         * </p>
         * 
         * @param instanceUrl
         *        The URL of the self-managed GitLab instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUrl(String instanceUrl);

        /**
         * <p>
         * The personal access token used to authenticate with the self-managed GitLab instance.
         * </p>
         * 
         * @param accessToken
         *        The personal access token used to authenticate with the self-managed GitLab instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);
    }

    static final class BuilderImpl implements Builder {
        private String instanceUrl;

        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGitLabSelfManagedIntegrationDetail model) {
            instanceUrl(model.instanceUrl);
            accessToken(model.accessToken);
        }

        public final String getInstanceUrl() {
            return instanceUrl;
        }

        public final void setInstanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
        }

        @Override
        public final Builder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public CreateGitLabSelfManagedIntegrationDetail build() {
            return new CreateGitLabSelfManagedIntegrationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
