/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSbomExportRequest extends Inspector2Request implements
        ToCopyableBuilder<CreateSbomExportRequest.Builder, CreateSbomExportRequest> {
    private static final SdkField<ResourceFilterCriteria> RESOURCE_FILTER_CRITERIA_FIELD = SdkField
            .<ResourceFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("resourceFilterCriteria")
            .getter(getter(CreateSbomExportRequest::resourceFilterCriteria)).setter(setter(Builder::resourceFilterCriteria))
            .constructor(ResourceFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceFilterCriteria").build())
            .build();

    private static final SdkField<String> REPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportFormat").getter(getter(CreateSbomExportRequest::reportFormatAsString))
            .setter(setter(Builder::reportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFormat").build()).build();

    private static final SdkField<Destination> S3_DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("s3Destination").getter(getter(CreateSbomExportRequest::s3Destination))
            .setter(setter(Builder::s3Destination)).constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_FILTER_CRITERIA_FIELD, REPORT_FORMAT_FIELD, S3_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourceFilterCriteria resourceFilterCriteria;

    private final String reportFormat;

    private final Destination s3Destination;

    private CreateSbomExportRequest(BuilderImpl builder) {
        super(builder);
        this.resourceFilterCriteria = builder.resourceFilterCriteria;
        this.reportFormat = builder.reportFormat;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * The resource filter criteria for the software bill of materials (SBOM) report.
     * </p>
     * 
     * @return The resource filter criteria for the software bill of materials (SBOM) report.
     */
    public final ResourceFilterCriteria resourceFilterCriteria() {
        return resourceFilterCriteria;
    }

    /**
     * <p>
     * The output format for the software bill of materials (SBOM) report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFormat} will
     * return {@link SbomReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportFormatAsString}.
     * </p>
     * 
     * @return The output format for the software bill of materials (SBOM) report.
     * @see SbomReportFormat
     */
    public final SbomReportFormat reportFormat() {
        return SbomReportFormat.fromValue(reportFormat);
    }

    /**
     * <p>
     * The output format for the software bill of materials (SBOM) report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFormat} will
     * return {@link SbomReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportFormatAsString}.
     * </p>
     * 
     * @return The output format for the software bill of materials (SBOM) report.
     * @see SbomReportFormat
     */
    public final String reportFormatAsString() {
        return reportFormat;
    }

    /**
     * <p>
     * Contains details of the Amazon S3 bucket and KMS key used to export findings.
     * </p>
     * 
     * @return Contains details of the Amazon S3 bucket and KMS key used to export findings.
     */
    public final Destination s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceFilterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(reportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSbomExportRequest)) {
            return false;
        }
        CreateSbomExportRequest other = (CreateSbomExportRequest) obj;
        return Objects.equals(resourceFilterCriteria(), other.resourceFilterCriteria())
                && Objects.equals(reportFormatAsString(), other.reportFormatAsString())
                && Objects.equals(s3Destination(), other.s3Destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSbomExportRequest").add("ResourceFilterCriteria", resourceFilterCriteria())
                .add("ReportFormat", reportFormatAsString()).add("S3Destination", s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceFilterCriteria":
            return Optional.ofNullable(clazz.cast(resourceFilterCriteria()));
        case "reportFormat":
            return Optional.ofNullable(clazz.cast(reportFormatAsString()));
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceFilterCriteria", RESOURCE_FILTER_CRITERIA_FIELD);
        map.put("reportFormat", REPORT_FORMAT_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSbomExportRequest, T> g) {
        return obj -> g.apply((CreateSbomExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSbomExportRequest> {
        /**
         * <p>
         * The resource filter criteria for the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param resourceFilterCriteria
         *        The resource filter criteria for the software bill of materials (SBOM) report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceFilterCriteria(ResourceFilterCriteria resourceFilterCriteria);

        /**
         * <p>
         * The resource filter criteria for the software bill of materials (SBOM) report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link ResourceFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceFilterCriteria(ResourceFilterCriteria)}.
         * 
         * @param resourceFilterCriteria
         *        a consumer that will call methods on {@link ResourceFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceFilterCriteria(ResourceFilterCriteria)
         */
        default Builder resourceFilterCriteria(Consumer<ResourceFilterCriteria.Builder> resourceFilterCriteria) {
            return resourceFilterCriteria(ResourceFilterCriteria.builder().applyMutation(resourceFilterCriteria).build());
        }

        /**
         * <p>
         * The output format for the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param reportFormat
         *        The output format for the software bill of materials (SBOM) report.
         * @see SbomReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomReportFormat
         */
        Builder reportFormat(String reportFormat);

        /**
         * <p>
         * The output format for the software bill of materials (SBOM) report.
         * </p>
         * 
         * @param reportFormat
         *        The output format for the software bill of materials (SBOM) report.
         * @see SbomReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomReportFormat
         */
        Builder reportFormat(SbomReportFormat reportFormat);

        /**
         * <p>
         * Contains details of the Amazon S3 bucket and KMS key used to export findings.
         * </p>
         * 
         * @param s3Destination
         *        Contains details of the Amazon S3 bucket and KMS key used to export findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(Destination s3Destination);

        /**
         * <p>
         * Contains details of the Amazon S3 bucket and KMS key used to export findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Destination(Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(Destination)
         */
        default Builder s3Destination(Consumer<Destination.Builder> s3Destination) {
            return s3Destination(Destination.builder().applyMutation(s3Destination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private ResourceFilterCriteria resourceFilterCriteria;

        private String reportFormat;

        private Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSbomExportRequest model) {
            super(model);
            resourceFilterCriteria(model.resourceFilterCriteria);
            reportFormat(model.reportFormat);
            s3Destination(model.s3Destination);
        }

        public final ResourceFilterCriteria.Builder getResourceFilterCriteria() {
            return resourceFilterCriteria != null ? resourceFilterCriteria.toBuilder() : null;
        }

        public final void setResourceFilterCriteria(ResourceFilterCriteria.BuilderImpl resourceFilterCriteria) {
            this.resourceFilterCriteria = resourceFilterCriteria != null ? resourceFilterCriteria.build() : null;
        }

        @Override
        public final Builder resourceFilterCriteria(ResourceFilterCriteria resourceFilterCriteria) {
            this.resourceFilterCriteria = resourceFilterCriteria;
            return this;
        }

        public final String getReportFormat() {
            return reportFormat;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        @Override
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        public final Builder reportFormat(SbomReportFormat reportFormat) {
            this.reportFormat(reportFormat == null ? null : reportFormat.toString());
            return this;
        }

        public final Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSbomExportRequest build() {
            return new CreateSbomExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
