/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about a member account in your organization that failed to activate Amazon Inspector
 * deep inspection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedMemberAccountEc2DeepInspectionStatusState
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<FailedMemberAccountEc2DeepInspectionStatusState.Builder, FailedMemberAccountEc2DeepInspectionStatusState> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(FailedMemberAccountEc2DeepInspectionStatusState::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> EC2_SCAN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2ScanStatus").getter(getter(FailedMemberAccountEc2DeepInspectionStatusState::ec2ScanStatusAsString))
            .setter(setter(Builder::ec2ScanStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2ScanStatus").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(FailedMemberAccountEc2DeepInspectionStatusState::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            EC2_SCAN_STATUS_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String ec2ScanStatus;

    private final String errorMessage;

    private FailedMemberAccountEc2DeepInspectionStatusState(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.ec2ScanStatus = builder.ec2ScanStatus;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account of the organization member that failed to activate
     * Amazon Inspector deep inspection.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account of the organization member that failed to
     *         activate Amazon Inspector deep inspection.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2ScanStatus}
     * will return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ec2ScanStatusAsString}.
     * </p>
     * 
     * @return The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
     * @see Status
     */
    public final Status ec2ScanStatus() {
        return Status.fromValue(ec2ScanStatus);
    }

    /**
     * <p>
     * The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2ScanStatus}
     * will return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ec2ScanStatusAsString}.
     * </p>
     * 
     * @return The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
     * @see Status
     */
    public final String ec2ScanStatusAsString() {
        return ec2ScanStatus;
    }

    /**
     * <p>
     * The error message explaining why the account failed to activate Amazon Inspector deep inspection.
     * </p>
     * 
     * @return The error message explaining why the account failed to activate Amazon Inspector deep inspection.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ScanStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedMemberAccountEc2DeepInspectionStatusState)) {
            return false;
        }
        FailedMemberAccountEc2DeepInspectionStatusState other = (FailedMemberAccountEc2DeepInspectionStatusState) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(ec2ScanStatusAsString(), other.ec2ScanStatusAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedMemberAccountEc2DeepInspectionStatusState").add("AccountId", accountId())
                .add("Ec2ScanStatus", ec2ScanStatusAsString()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ec2ScanStatus":
            return Optional.ofNullable(clazz.cast(ec2ScanStatusAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("ec2ScanStatus", EC2_SCAN_STATUS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedMemberAccountEc2DeepInspectionStatusState, T> g) {
        return obj -> g.apply((FailedMemberAccountEc2DeepInspectionStatusState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedMemberAccountEc2DeepInspectionStatusState> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account of the organization member that failed to activate
         * Amazon Inspector deep inspection.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account of the organization member that failed to
         *        activate Amazon Inspector deep inspection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
         * </p>
         * 
         * @param ec2ScanStatus
         *        The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder ec2ScanStatus(String ec2ScanStatus);

        /**
         * <p>
         * The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
         * </p>
         * 
         * @param ec2ScanStatus
         *        The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder ec2ScanStatus(Status ec2ScanStatus);

        /**
         * <p>
         * The error message explaining why the account failed to activate Amazon Inspector deep inspection.
         * </p>
         * 
         * @param errorMessage
         *        The error message explaining why the account failed to activate Amazon Inspector deep inspection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String ec2ScanStatus;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedMemberAccountEc2DeepInspectionStatusState model) {
            accountId(model.accountId);
            ec2ScanStatus(model.ec2ScanStatus);
            errorMessage(model.errorMessage);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getEc2ScanStatus() {
            return ec2ScanStatus;
        }

        public final void setEc2ScanStatus(String ec2ScanStatus) {
            this.ec2ScanStatus = ec2ScanStatus;
        }

        @Override
        public final Builder ec2ScanStatus(String ec2ScanStatus) {
            this.ec2ScanStatus = ec2ScanStatus;
            return this;
        }

        @Override
        public final Builder ec2ScanStatus(Status ec2ScanStatus) {
            this.ec2ScanStatus(ec2ScanStatus == null ? null : ec2ScanStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public FailedMemberAccountEc2DeepInspectionStatusState build() {
            return new FailedMemberAccountEc2DeepInspectionStatusState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
