/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCodeSecurityScanConfigurationResponse extends Inspector2Response implements
        ToCopyableBuilder<GetCodeSecurityScanConfigurationResponse.Builder, GetCodeSecurityScanConfigurationResponse> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(GetCodeSecurityScanConfigurationResponse::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCodeSecurityScanConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<CodeSecurityScanConfiguration> CONFIGURATION_FIELD = SdkField
            .<CodeSecurityScanConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(GetCodeSecurityScanConfigurationResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(CodeSecurityScanConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("level")
            .getter(getter(GetCodeSecurityScanConfigurationResponse::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<ScopeSettings> SCOPE_SETTINGS_FIELD = SdkField
            .<ScopeSettings> builder(MarshallingType.SDK_POJO).memberName("scopeSettings")
            .getter(getter(GetCodeSecurityScanConfigurationResponse::scopeSettings)).setter(setter(Builder::scopeSettings))
            .constructor(ScopeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeSettings").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetCodeSecurityScanConfigurationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(GetCodeSecurityScanConfigurationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetCodeSecurityScanConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            NAME_FIELD, CONFIGURATION_FIELD, LEVEL_FIELD, SCOPE_SETTINGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scanConfigurationArn;

    private final String name;

    private final CodeSecurityScanConfiguration configuration;

    private final String level;

    private final ScopeSettings scopeSettings;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Map<String, String> tags;

    private GetCodeSecurityScanConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.level = builder.level;
        this.scopeSettings = builder.scopeSettings;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scan configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scan configuration.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * <p>
     * The name of the scan configuration.
     * </p>
     * 
     * @return The name of the scan configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration settings for the code security scan.
     * </p>
     * 
     * @return The configuration settings for the code security scan.
     */
    public final CodeSecurityScanConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The security level for the scan configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link ConfigurationLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The security level for the scan configuration.
     * @see ConfigurationLevel
     */
    public final ConfigurationLevel level() {
        return ConfigurationLevel.fromValue(level);
    }

    /**
     * <p>
     * The security level for the scan configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link ConfigurationLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The security level for the scan configuration.
     * @see ConfigurationLevel
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * <p>
     * The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code> parameter is
     * <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon
     * Inspector.
     * </p>
     * 
     * @return The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code>
     *         parameter is <code>ALL</code> the scan configuration applies to all existing and future projects imported
     *         into Amazon Inspector.
     */
    public final ScopeSettings scopeSettings() {
        return scopeSettings;
    }

    /**
     * <p>
     * The timestamp when the scan configuration was created.
     * </p>
     * 
     * @return The timestamp when the scan configuration was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the scan configuration was last updated.
     * </p>
     * 
     * @return The timestamp when the scan configuration was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the scan configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeSecurityScanConfigurationResponse)) {
            return false;
        }
        GetCodeSecurityScanConfigurationResponse other = (GetCodeSecurityScanConfigurationResponse) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(scopeSettings(), other.scopeSettings()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCodeSecurityScanConfigurationResponse").add("ScanConfigurationArn", scanConfigurationArn())
                .add("Name", name()).add("Configuration", configuration()).add("Level", levelAsString())
                .add("ScopeSettings", scopeSettings()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "scopeSettings":
            return Optional.ofNullable(clazz.cast(scopeSettings()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("scopeSettings", SCOPE_SETTINGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeSecurityScanConfigurationResponse, T> g) {
        return obj -> g.apply((GetCodeSecurityScanConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCodeSecurityScanConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scan configuration.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The Amazon Resource Name (ARN) of the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * <p>
         * The name of the scan configuration.
         * </p>
         * 
         * @param name
         *        The name of the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration settings for the code security scan.
         * </p>
         * 
         * @param configuration
         *        The configuration settings for the code security scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CodeSecurityScanConfiguration configuration);

        /**
         * <p>
         * The configuration settings for the code security scan.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeSecurityScanConfiguration.Builder}
         * avoiding the need to create one manually via {@link CodeSecurityScanConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeSecurityScanConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(CodeSecurityScanConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CodeSecurityScanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CodeSecurityScanConfiguration)
         */
        default Builder configuration(Consumer<CodeSecurityScanConfiguration.Builder> configuration) {
            return configuration(CodeSecurityScanConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The security level for the scan configuration.
         * </p>
         * 
         * @param level
         *        The security level for the scan configuration.
         * @see ConfigurationLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationLevel
         */
        Builder level(String level);

        /**
         * <p>
         * The security level for the scan configuration.
         * </p>
         * 
         * @param level
         *        The security level for the scan configuration.
         * @see ConfigurationLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationLevel
         */
        Builder level(ConfigurationLevel level);

        /**
         * <p>
         * The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code> parameter
         * is <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon
         * Inspector.
         * </p>
         * 
         * @param scopeSettings
         *        The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code>
         *        parameter is <code>ALL</code> the scan configuration applies to all existing and future projects
         *        imported into Amazon Inspector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeSettings(ScopeSettings scopeSettings);

        /**
         * <p>
         * The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code> parameter
         * is <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon
         * Inspector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScopeSettings.Builder} avoiding the need
         * to create one manually via {@link ScopeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScopeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #scopeSettings(ScopeSettings)}.
         * 
         * @param scopeSettings
         *        a consumer that will call methods on {@link ScopeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopeSettings(ScopeSettings)
         */
        default Builder scopeSettings(Consumer<ScopeSettings.Builder> scopeSettings) {
            return scopeSettings(ScopeSettings.builder().applyMutation(scopeSettings).build());
        }

        /**
         * <p>
         * The timestamp when the scan configuration was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the scan configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the scan configuration was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the scan configuration was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The tags associated with the scan configuration.
         * </p>
         * 
         * @param tags
         *        The tags associated with the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private String name;

        private CodeSecurityScanConfiguration configuration;

        private String level;

        private ScopeSettings scopeSettings;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeSecurityScanConfigurationResponse model) {
            super(model);
            scanConfigurationArn(model.scanConfigurationArn);
            name(model.name);
            configuration(model.configuration);
            level(model.level);
            scopeSettings(model.scopeSettings);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            tags(model.tags);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CodeSecurityScanConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(CodeSecurityScanConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CodeSecurityScanConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(ConfigurationLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final ScopeSettings.Builder getScopeSettings() {
            return scopeSettings != null ? scopeSettings.toBuilder() : null;
        }

        public final void setScopeSettings(ScopeSettings.BuilderImpl scopeSettings) {
            this.scopeSettings = scopeSettings != null ? scopeSettings.build() : null;
        }

        @Override
        public final Builder scopeSettings(ScopeSettings scopeSettings) {
            this.scopeSettings = scopeSettings;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetCodeSecurityScanConfigurationResponse build() {
            return new GetCodeSecurityScanConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
