/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeSecurityScanConfigurationAssociationsRequest extends Inspector2Request
        implements
        ToCopyableBuilder<ListCodeSecurityScanConfigurationAssociationsRequest.Builder, ListCodeSecurityScanConfigurationAssociationsRequest> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn")
            .getter(getter(ListCodeSecurityScanConfigurationAssociationsRequest::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCodeSecurityScanConfigurationAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCodeSecurityScanConfigurationAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scanConfigurationArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListCodeSecurityScanConfigurationAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scan configuration to list associations for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scan configuration to list associations for.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from
     * the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code>
     *         value returned from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     * 
     * @return The maximum number of results to return in the response. If your request would return more than the
     *         maximum the response will return a <code>nextToken</code> value, use this value when you call the action
     *         again to get the remaining results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSecurityScanConfigurationAssociationsRequest)) {
            return false;
        }
        ListCodeSecurityScanConfigurationAssociationsRequest other = (ListCodeSecurityScanConfigurationAssociationsRequest) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCodeSecurityScanConfigurationAssociationsRequest")
                .add("ScanConfigurationArn", scanConfigurationArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSecurityScanConfigurationAssociationsRequest, T> g) {
        return obj -> g.apply((ListCodeSecurityScanConfigurationAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCodeSecurityScanConfigurationAssociationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scan configuration to list associations for.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The Amazon Resource Name (ARN) of the scan configuration to list associations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value
         * returned from the previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the
         *        <code>NextToken</code> value returned from the previous request to continue listing results after the
         *        first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response. If your request would return more than the maximum
         * the response will return a <code>nextToken</code> value, use this value when you call the action again to get
         * the remaining results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response. If your request would return more than the
         *        maximum the response will return a <code>nextToken</code> value, use this value when you call the
         *        action again to get the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSecurityScanConfigurationAssociationsRequest model) {
            super(model);
            scanConfigurationArn(model.scanConfigurationArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCodeSecurityScanConfigurationAssociationsRequest build() {
            return new ListCodeSecurityScanConfigurationAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
