/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a member account in your organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Member implements SdkPojo, Serializable, ToCopyableBuilder<Member.Builder, Member> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(Member::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationshipStatus").getter(getter(Member::relationshipStatusAsString))
            .setter(setter(Builder::relationshipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build())
            .build();

    private static final SdkField<String> DELEGATED_ADMIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("delegatedAdminAccountId").getter(getter(Member::delegatedAdminAccountId))
            .setter(setter(Builder::delegatedAdminAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdminAccountId").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Member::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RELATIONSHIP_STATUS_FIELD, DELEGATED_ADMIN_ACCOUNT_ID_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String relationshipStatus;

    private final String delegatedAdminAccountId;

    private final Instant updatedAt;

    private Member(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.relationshipStatus = builder.relationshipStatus;
        this.delegatedAdminAccountId = builder.delegatedAdminAccountId;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the member account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The status of the member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationshipStatus} will return {@link RelationshipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #relationshipStatusAsString}.
     * </p>
     * 
     * @return The status of the member account.
     * @see RelationshipStatus
     */
    public final RelationshipStatus relationshipStatus() {
        return RelationshipStatus.fromValue(relationshipStatus);
    }

    /**
     * <p>
     * The status of the member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationshipStatus} will return {@link RelationshipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #relationshipStatusAsString}.
     * </p>
     * 
     * @return The status of the member account.
     * @see RelationshipStatus
     */
    public final String relationshipStatusAsString() {
        return relationshipStatus;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member
     *         account.
     */
    public final String delegatedAdminAccountId() {
        return delegatedAdminAccountId;
    }

    /**
     * <p>
     * A timestamp showing when the status of this member was last updated.
     * </p>
     * 
     * @return A timestamp showing when the status of this member was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(delegatedAdminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(relationshipStatusAsString(), other.relationshipStatusAsString())
                && Objects.equals(delegatedAdminAccountId(), other.delegatedAdminAccountId())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Member").add("AccountId", accountId()).add("RelationshipStatus", relationshipStatusAsString())
                .add("DelegatedAdminAccountId", delegatedAdminAccountId()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "relationshipStatus":
            return Optional.ofNullable(clazz.cast(relationshipStatusAsString()));
        case "delegatedAdminAccountId":
            return Optional.ofNullable(clazz.cast(delegatedAdminAccountId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("relationshipStatus", RELATIONSHIP_STATUS_FIELD);
        map.put("delegatedAdminAccountId", DELEGATED_ADMIN_ACCOUNT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Member> {
        /**
         * <p>
         * The Amazon Web Services account ID of the member account.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The status of the member account.
         * </p>
         * 
         * @param relationshipStatus
         *        The status of the member account.
         * @see RelationshipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipStatus
         */
        Builder relationshipStatus(String relationshipStatus);

        /**
         * <p>
         * The status of the member account.
         * </p>
         * 
         * @param relationshipStatus
         *        The status of the member account.
         * @see RelationshipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipStatus
         */
        Builder relationshipStatus(RelationshipStatus relationshipStatus);

        /**
         * <p>
         * The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.
         * </p>
         * 
         * @param delegatedAdminAccountId
         *        The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdminAccountId(String delegatedAdminAccountId);

        /**
         * <p>
         * A timestamp showing when the status of this member was last updated.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp showing when the status of this member was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String relationshipStatus;

        private String delegatedAdminAccountId;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            accountId(model.accountId);
            relationshipStatus(model.relationshipStatus);
            delegatedAdminAccountId(model.delegatedAdminAccountId);
            updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRelationshipStatus() {
            return relationshipStatus;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        @Override
        public final Builder relationshipStatus(RelationshipStatus relationshipStatus) {
            this.relationshipStatus(relationshipStatus == null ? null : relationshipStatus.toString());
            return this;
        }

        public final String getDelegatedAdminAccountId() {
            return delegatedAdminAccountId;
        }

        public final void setDelegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
        }

        @Override
        public final Builder delegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Member build() {
            return new Member(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
