/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for periodic scans that run on a scheduled basis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PeriodicScanConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PeriodicScanConfiguration.Builder, PeriodicScanConfiguration> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frequency").getter(getter(PeriodicScanConfiguration::frequencyAsString))
            .setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<String> FREQUENCY_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frequencyExpression").getter(getter(PeriodicScanConfiguration::frequencyExpression))
            .setter(setter(Builder::frequencyExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequencyExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD,
            FREQUENCY_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String frequency;

    private final String frequencyExpression;

    private PeriodicScanConfiguration(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.frequencyExpression = builder.frequencyExpression;
    }

    /**
     * <p>
     * The frequency at which periodic scans are performed (such as weekly or monthly).
     * </p>
     * <p>
     * If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to run. If
     * you provide the <code>frequencyExpression</code>, the schedule must match the specified <code>frequency</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link PeriodicScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency at which periodic scans are performed (such as weekly or monthly).</p>
     *         <p>
     *         If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to
     *         run. If you provide the <code>frequencyExpression</code>, the schedule must match the specified
     *         <code>frequency</code>.
     * @see PeriodicScanFrequency
     */
    public final PeriodicScanFrequency frequency() {
        return PeriodicScanFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * The frequency at which periodic scans are performed (such as weekly or monthly).
     * </p>
     * <p>
     * If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to run. If
     * you provide the <code>frequencyExpression</code>, the schedule must match the specified <code>frequency</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link PeriodicScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #frequencyAsString}.
     * </p>
     * 
     * @return The frequency at which periodic scans are performed (such as weekly or monthly).</p>
     *         <p>
     *         If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to
     *         run. If you provide the <code>frequencyExpression</code>, the schedule must match the specified
     *         <code>frequency</code>.
     * @see PeriodicScanFrequency
     */
    public final String frequencyAsString() {
        return frequency;
    }

    /**
     * <p>
     * The schedule expression for periodic scans, in cron format.
     * </p>
     * 
     * @return The schedule expression for periodic scans, in cron format.
     */
    public final String frequencyExpression() {
        return frequencyExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeriodicScanConfiguration)) {
            return false;
        }
        PeriodicScanConfiguration other = (PeriodicScanConfiguration) obj;
        return Objects.equals(frequencyAsString(), other.frequencyAsString())
                && Objects.equals(frequencyExpression(), other.frequencyExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PeriodicScanConfiguration").add("Frequency", frequencyAsString())
                .add("FrequencyExpression", frequencyExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "frequencyExpression":
            return Optional.ofNullable(clazz.cast(frequencyExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("frequency", FREQUENCY_FIELD);
        map.put("frequencyExpression", FREQUENCY_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PeriodicScanConfiguration, T> g) {
        return obj -> g.apply((PeriodicScanConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PeriodicScanConfiguration> {
        /**
         * <p>
         * The frequency at which periodic scans are performed (such as weekly or monthly).
         * </p>
         * <p>
         * If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to run.
         * If you provide the <code>frequencyExpression</code>, the schedule must match the specified
         * <code>frequency</code>.
         * </p>
         * 
         * @param frequency
         *        The frequency at which periodic scans are performed (such as weekly or monthly).</p>
         *        <p>
         *        If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to
         *        run. If you provide the <code>frequencyExpression</code>, the schedule must match the specified
         *        <code>frequency</code>.
         * @see PeriodicScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodicScanFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The frequency at which periodic scans are performed (such as weekly or monthly).
         * </p>
         * <p>
         * If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to run.
         * If you provide the <code>frequencyExpression</code>, the schedule must match the specified
         * <code>frequency</code>.
         * </p>
         * 
         * @param frequency
         *        The frequency at which periodic scans are performed (such as weekly or monthly).</p>
         *        <p>
         *        If you don't provide the <code>frequencyExpression</code> Amazon Inspector chooses day for the scan to
         *        run. If you provide the <code>frequencyExpression</code>, the schedule must match the specified
         *        <code>frequency</code>.
         * @see PeriodicScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodicScanFrequency
         */
        Builder frequency(PeriodicScanFrequency frequency);

        /**
         * <p>
         * The schedule expression for periodic scans, in cron format.
         * </p>
         * 
         * @param frequencyExpression
         *        The schedule expression for periodic scans, in cron format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequencyExpression(String frequencyExpression);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private String frequencyExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(PeriodicScanConfiguration model) {
            frequency(model.frequency);
            frequencyExpression(model.frequencyExpression);
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(PeriodicScanFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getFrequencyExpression() {
            return frequencyExpression;
        }

        public final void setFrequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
        }

        @Override
        public final Builder frequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
            return this;
        }

        @Override
        public PeriodicScanConfiguration build() {
            return new PeriodicScanConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
