/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the scan configuration settings applied to a specific project in a code repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectCodeSecurityScanConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectCodeSecurityScanConfiguration.Builder, ProjectCodeSecurityScanConfiguration> {
    private static final SdkField<List<ProjectPeriodicScanConfiguration>> PERIODIC_SCAN_CONFIGURATIONS_FIELD = SdkField
            .<List<ProjectPeriodicScanConfiguration>> builder(MarshallingType.LIST)
            .memberName("periodicScanConfigurations")
            .getter(getter(ProjectCodeSecurityScanConfiguration::periodicScanConfigurations))
            .setter(setter(Builder::periodicScanConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodicScanConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectPeriodicScanConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectPeriodicScanConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProjectContinuousIntegrationScanConfiguration>> CONTINUOUS_INTEGRATION_SCAN_CONFIGURATIONS_FIELD = SdkField
            .<List<ProjectContinuousIntegrationScanConfiguration>> builder(MarshallingType.LIST)
            .memberName("continuousIntegrationScanConfigurations")
            .getter(getter(ProjectCodeSecurityScanConfiguration::continuousIntegrationScanConfigurations))
            .setter(setter(Builder::continuousIntegrationScanConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("continuousIntegrationScanConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectContinuousIntegrationScanConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectContinuousIntegrationScanConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERIODIC_SCAN_CONFIGURATIONS_FIELD, CONTINUOUS_INTEGRATION_SCAN_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ProjectPeriodicScanConfiguration> periodicScanConfigurations;

    private final List<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations;

    private ProjectCodeSecurityScanConfiguration(BuilderImpl builder) {
        this.periodicScanConfigurations = builder.periodicScanConfigurations;
        this.continuousIntegrationScanConfigurations = builder.continuousIntegrationScanConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the PeriodicScanConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPeriodicScanConfigurations() {
        return periodicScanConfigurations != null && !(periodicScanConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The periodic scan configurations applied to the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeriodicScanConfigurations} method.
     * </p>
     * 
     * @return The periodic scan configurations applied to the project.
     */
    public final List<ProjectPeriodicScanConfiguration> periodicScanConfigurations() {
        return periodicScanConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContinuousIntegrationScanConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasContinuousIntegrationScanConfigurations() {
        return continuousIntegrationScanConfigurations != null
                && !(continuousIntegrationScanConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The continuous integration scan configurations applied to the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasContinuousIntegrationScanConfigurations} method.
     * </p>
     * 
     * @return The continuous integration scan configurations applied to the project.
     */
    public final List<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations() {
        return continuousIntegrationScanConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPeriodicScanConfigurations() ? periodicScanConfigurations() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasContinuousIntegrationScanConfigurations() ? continuousIntegrationScanConfigurations()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectCodeSecurityScanConfiguration)) {
            return false;
        }
        ProjectCodeSecurityScanConfiguration other = (ProjectCodeSecurityScanConfiguration) obj;
        return hasPeriodicScanConfigurations() == other.hasPeriodicScanConfigurations()
                && Objects.equals(periodicScanConfigurations(), other.periodicScanConfigurations())
                && hasContinuousIntegrationScanConfigurations() == other.hasContinuousIntegrationScanConfigurations()
                && Objects.equals(continuousIntegrationScanConfigurations(), other.continuousIntegrationScanConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ProjectCodeSecurityScanConfiguration")
                .add("PeriodicScanConfigurations", hasPeriodicScanConfigurations() ? periodicScanConfigurations() : null)
                .add("ContinuousIntegrationScanConfigurations",
                        hasContinuousIntegrationScanConfigurations() ? continuousIntegrationScanConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "periodicScanConfigurations":
            return Optional.ofNullable(clazz.cast(periodicScanConfigurations()));
        case "continuousIntegrationScanConfigurations":
            return Optional.ofNullable(clazz.cast(continuousIntegrationScanConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("periodicScanConfigurations", PERIODIC_SCAN_CONFIGURATIONS_FIELD);
        map.put("continuousIntegrationScanConfigurations", CONTINUOUS_INTEGRATION_SCAN_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectCodeSecurityScanConfiguration, T> g) {
        return obj -> g.apply((ProjectCodeSecurityScanConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectCodeSecurityScanConfiguration> {
        /**
         * <p>
         * The periodic scan configurations applied to the project.
         * </p>
         * 
         * @param periodicScanConfigurations
         *        The periodic scan configurations applied to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodicScanConfigurations(Collection<ProjectPeriodicScanConfiguration> periodicScanConfigurations);

        /**
         * <p>
         * The periodic scan configurations applied to the project.
         * </p>
         * 
         * @param periodicScanConfigurations
         *        The periodic scan configurations applied to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodicScanConfigurations(ProjectPeriodicScanConfiguration... periodicScanConfigurations);

        /**
         * <p>
         * The periodic scan configurations applied to the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ProjectPeriodicScanConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ProjectPeriodicScanConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ProjectPeriodicScanConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #periodicScanConfigurations(List<ProjectPeriodicScanConfiguration>)}.
         * 
         * @param periodicScanConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ProjectPeriodicScanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #periodicScanConfigurations(java.util.Collection<ProjectPeriodicScanConfiguration>)
         */
        Builder periodicScanConfigurations(Consumer<ProjectPeriodicScanConfiguration.Builder>... periodicScanConfigurations);

        /**
         * <p>
         * The continuous integration scan configurations applied to the project.
         * </p>
         * 
         * @param continuousIntegrationScanConfigurations
         *        The continuous integration scan configurations applied to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanConfigurations(
                Collection<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations);

        /**
         * <p>
         * The continuous integration scan configurations applied to the project.
         * </p>
         * 
         * @param continuousIntegrationScanConfigurations
         *        The continuous integration scan configurations applied to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanConfigurations(
                ProjectContinuousIntegrationScanConfiguration... continuousIntegrationScanConfigurations);

        /**
         * <p>
         * The continuous integration scan configurations applied to the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ProjectContinuousIntegrationScanConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.ProjectContinuousIntegrationScanConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ProjectContinuousIntegrationScanConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #continuousIntegrationScanConfigurations(List<ProjectContinuousIntegrationScanConfiguration>)}.
         * 
         * @param continuousIntegrationScanConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ProjectContinuousIntegrationScanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see 
         *      #continuousIntegrationScanConfigurations(java.util.Collection<ProjectContinuousIntegrationScanConfiguration
         *      >)
         */
        Builder continuousIntegrationScanConfigurations(
                Consumer<ProjectContinuousIntegrationScanConfiguration.Builder>... continuousIntegrationScanConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<ProjectPeriodicScanConfiguration> periodicScanConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectCodeSecurityScanConfiguration model) {
            periodicScanConfigurations(model.periodicScanConfigurations);
            continuousIntegrationScanConfigurations(model.continuousIntegrationScanConfigurations);
        }

        public final List<ProjectPeriodicScanConfiguration.Builder> getPeriodicScanConfigurations() {
            List<ProjectPeriodicScanConfiguration.Builder> result = ProjectPeriodicScanConfigurationListCopier
                    .copyToBuilder(this.periodicScanConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPeriodicScanConfigurations(
                Collection<ProjectPeriodicScanConfiguration.BuilderImpl> periodicScanConfigurations) {
            this.periodicScanConfigurations = ProjectPeriodicScanConfigurationListCopier
                    .copyFromBuilder(periodicScanConfigurations);
        }

        @Override
        public final Builder periodicScanConfigurations(Collection<ProjectPeriodicScanConfiguration> periodicScanConfigurations) {
            this.periodicScanConfigurations = ProjectPeriodicScanConfigurationListCopier.copy(periodicScanConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodicScanConfigurations(ProjectPeriodicScanConfiguration... periodicScanConfigurations) {
            periodicScanConfigurations(Arrays.asList(periodicScanConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodicScanConfigurations(
                Consumer<ProjectPeriodicScanConfiguration.Builder>... periodicScanConfigurations) {
            periodicScanConfigurations(Stream.of(periodicScanConfigurations)
                    .map(c -> ProjectPeriodicScanConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectContinuousIntegrationScanConfiguration.Builder> getContinuousIntegrationScanConfigurations() {
            List<ProjectContinuousIntegrationScanConfiguration.Builder> result = ProjectContinuousIntegrationScanConfigurationListCopier
                    .copyToBuilder(this.continuousIntegrationScanConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContinuousIntegrationScanConfigurations(
                Collection<ProjectContinuousIntegrationScanConfiguration.BuilderImpl> continuousIntegrationScanConfigurations) {
            this.continuousIntegrationScanConfigurations = ProjectContinuousIntegrationScanConfigurationListCopier
                    .copyFromBuilder(continuousIntegrationScanConfigurations);
        }

        @Override
        public final Builder continuousIntegrationScanConfigurations(
                Collection<ProjectContinuousIntegrationScanConfiguration> continuousIntegrationScanConfigurations) {
            this.continuousIntegrationScanConfigurations = ProjectContinuousIntegrationScanConfigurationListCopier
                    .copy(continuousIntegrationScanConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanConfigurations(
                ProjectContinuousIntegrationScanConfiguration... continuousIntegrationScanConfigurations) {
            continuousIntegrationScanConfigurations(Arrays.asList(continuousIntegrationScanConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanConfigurations(
                Consumer<ProjectContinuousIntegrationScanConfiguration.Builder>... continuousIntegrationScanConfigurations) {
            continuousIntegrationScanConfigurations(Stream.of(continuousIntegrationScanConfigurations)
                    .map(c -> ProjectContinuousIntegrationScanConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProjectCodeSecurityScanConfiguration build() {
            return new ProjectCodeSecurityScanConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
