/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the continuous integration scan configuration settings applied to a specific project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectContinuousIntegrationScanConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectContinuousIntegrationScanConfiguration.Builder, ProjectContinuousIntegrationScanConfiguration> {
    private static final SdkField<String> SUPPORTED_EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportedEvent").getter(getter(ProjectContinuousIntegrationScanConfiguration::supportedEventAsString))
            .setter(setter(Builder::supportedEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEvent").build()).build();

    private static final SdkField<List<String>> RULE_SET_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ruleSetCategories")
            .getter(getter(ProjectContinuousIntegrationScanConfiguration::ruleSetCategoriesAsStrings))
            .setter(setter(Builder::ruleSetCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleSetCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_EVENT_FIELD,
            RULE_SET_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String supportedEvent;

    private final List<String> ruleSetCategories;

    private ProjectContinuousIntegrationScanConfiguration(BuilderImpl builder) {
        this.supportedEvent = builder.supportedEvent;
        this.ruleSetCategories = builder.ruleSetCategories;
    }

    /**
     * <p>
     * The repository event that triggers continuous integration scans for the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supportedEvent}
     * will return {@link ContinuousIntegrationScanEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #supportedEventAsString}.
     * </p>
     * 
     * @return The repository event that triggers continuous integration scans for the project.
     * @see ContinuousIntegrationScanEvent
     */
    public final ContinuousIntegrationScanEvent supportedEvent() {
        return ContinuousIntegrationScanEvent.fromValue(supportedEvent);
    }

    /**
     * <p>
     * The repository event that triggers continuous integration scans for the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supportedEvent}
     * will return {@link ContinuousIntegrationScanEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #supportedEventAsString}.
     * </p>
     * 
     * @return The repository event that triggers continuous integration scans for the project.
     * @see ContinuousIntegrationScanEvent
     */
    public final String supportedEventAsString() {
        return supportedEvent;
    }

    /**
     * <p>
     * The categories of security rules applied during continuous integration scans for the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetCategories} method.
     * </p>
     * 
     * @return The categories of security rules applied during continuous integration scans for the project.
     */
    public final List<RuleSetCategory> ruleSetCategories() {
        return RuleSetCategoriesCopier.copyStringToEnum(ruleSetCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleSetCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleSetCategories() {
        return ruleSetCategories != null && !(ruleSetCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categories of security rules applied during continuous integration scans for the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetCategories} method.
     * </p>
     * 
     * @return The categories of security rules applied during continuous integration scans for the project.
     */
    public final List<String> ruleSetCategoriesAsStrings() {
        return ruleSetCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(supportedEventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleSetCategories() ? ruleSetCategoriesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectContinuousIntegrationScanConfiguration)) {
            return false;
        }
        ProjectContinuousIntegrationScanConfiguration other = (ProjectContinuousIntegrationScanConfiguration) obj;
        return Objects.equals(supportedEventAsString(), other.supportedEventAsString())
                && hasRuleSetCategories() == other.hasRuleSetCategories()
                && Objects.equals(ruleSetCategoriesAsStrings(), other.ruleSetCategoriesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectContinuousIntegrationScanConfiguration").add("SupportedEvent", supportedEventAsString())
                .add("RuleSetCategories", hasRuleSetCategories() ? ruleSetCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "supportedEvent":
            return Optional.ofNullable(clazz.cast(supportedEventAsString()));
        case "ruleSetCategories":
            return Optional.ofNullable(clazz.cast(ruleSetCategoriesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("supportedEvent", SUPPORTED_EVENT_FIELD);
        map.put("ruleSetCategories", RULE_SET_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectContinuousIntegrationScanConfiguration, T> g) {
        return obj -> g.apply((ProjectContinuousIntegrationScanConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectContinuousIntegrationScanConfiguration> {
        /**
         * <p>
         * The repository event that triggers continuous integration scans for the project.
         * </p>
         * 
         * @param supportedEvent
         *        The repository event that triggers continuous integration scans for the project.
         * @see ContinuousIntegrationScanEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinuousIntegrationScanEvent
         */
        Builder supportedEvent(String supportedEvent);

        /**
         * <p>
         * The repository event that triggers continuous integration scans for the project.
         * </p>
         * 
         * @param supportedEvent
         *        The repository event that triggers continuous integration scans for the project.
         * @see ContinuousIntegrationScanEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContinuousIntegrationScanEvent
         */
        Builder supportedEvent(ContinuousIntegrationScanEvent supportedEvent);

        /**
         * <p>
         * The categories of security rules applied during continuous integration scans for the project.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during continuous integration scans for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories);

        /**
         * <p>
         * The categories of security rules applied during continuous integration scans for the project.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during continuous integration scans for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategoriesWithStrings(String... ruleSetCategories);

        /**
         * <p>
         * The categories of security rules applied during continuous integration scans for the project.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during continuous integration scans for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories);

        /**
         * <p>
         * The categories of security rules applied during continuous integration scans for the project.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during continuous integration scans for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategories(RuleSetCategory... ruleSetCategories);
    }

    static final class BuilderImpl implements Builder {
        private String supportedEvent;

        private List<String> ruleSetCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectContinuousIntegrationScanConfiguration model) {
            supportedEvent(model.supportedEvent);
            ruleSetCategoriesWithStrings(model.ruleSetCategories);
        }

        public final String getSupportedEvent() {
            return supportedEvent;
        }

        public final void setSupportedEvent(String supportedEvent) {
            this.supportedEvent = supportedEvent;
        }

        @Override
        public final Builder supportedEvent(String supportedEvent) {
            this.supportedEvent = supportedEvent;
            return this;
        }

        @Override
        public final Builder supportedEvent(ContinuousIntegrationScanEvent supportedEvent) {
            this.supportedEvent(supportedEvent == null ? null : supportedEvent.toString());
            return this;
        }

        public final Collection<String> getRuleSetCategories() {
            if (ruleSetCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleSetCategories;
        }

        public final void setRuleSetCategories(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
        }

        @Override
        public final Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategoriesWithStrings(String... ruleSetCategories) {
            ruleSetCategoriesWithStrings(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public final Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copyEnumToString(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategories(RuleSetCategory... ruleSetCategories) {
            ruleSetCategories(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public ProjectContinuousIntegrationScanConfiguration build() {
            return new ProjectContinuousIntegrationScanConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
