/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the scope of repositories to be included in code security scans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScopeSettings implements SdkPojo, Serializable, ToCopyableBuilder<ScopeSettings.Builder, ScopeSettings> {
    private static final SdkField<String> PROJECT_SELECTION_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectSelectionScope").getter(getter(ScopeSettings::projectSelectionScopeAsString))
            .setter(setter(Builder::projectSelectionScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectSelectionScope").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PROJECT_SELECTION_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String projectSelectionScope;

    private ScopeSettings(BuilderImpl builder) {
        this.projectSelectionScope = builder.projectSelectionScope;
    }

    /**
     * <p>
     * The scope of projects to be selected for scanning within the integrated repositories. Setting the value to
     * <code>ALL</code> applies the scope settings to all existing and future projects imported into Amazon Inspector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #projectSelectionScope} will return {@link ProjectSelectionScope#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #projectSelectionScopeAsString}.
     * </p>
     * 
     * @return The scope of projects to be selected for scanning within the integrated repositories. Setting the value
     *         to <code>ALL</code> applies the scope settings to all existing and future projects imported into Amazon
     *         Inspector.
     * @see ProjectSelectionScope
     */
    public final ProjectSelectionScope projectSelectionScope() {
        return ProjectSelectionScope.fromValue(projectSelectionScope);
    }

    /**
     * <p>
     * The scope of projects to be selected for scanning within the integrated repositories. Setting the value to
     * <code>ALL</code> applies the scope settings to all existing and future projects imported into Amazon Inspector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #projectSelectionScope} will return {@link ProjectSelectionScope#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #projectSelectionScopeAsString}.
     * </p>
     * 
     * @return The scope of projects to be selected for scanning within the integrated repositories. Setting the value
     *         to <code>ALL</code> applies the scope settings to all existing and future projects imported into Amazon
     *         Inspector.
     * @see ProjectSelectionScope
     */
    public final String projectSelectionScopeAsString() {
        return projectSelectionScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectSelectionScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeSettings)) {
            return false;
        }
        ScopeSettings other = (ScopeSettings) obj;
        return Objects.equals(projectSelectionScopeAsString(), other.projectSelectionScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScopeSettings").add("ProjectSelectionScope", projectSelectionScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectSelectionScope":
            return Optional.ofNullable(clazz.cast(projectSelectionScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectSelectionScope", PROJECT_SELECTION_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScopeSettings, T> g) {
        return obj -> g.apply((ScopeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScopeSettings> {
        /**
         * <p>
         * The scope of projects to be selected for scanning within the integrated repositories. Setting the value to
         * <code>ALL</code> applies the scope settings to all existing and future projects imported into Amazon
         * Inspector.
         * </p>
         * 
         * @param projectSelectionScope
         *        The scope of projects to be selected for scanning within the integrated repositories. Setting the
         *        value to <code>ALL</code> applies the scope settings to all existing and future projects imported into
         *        Amazon Inspector.
         * @see ProjectSelectionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectSelectionScope
         */
        Builder projectSelectionScope(String projectSelectionScope);

        /**
         * <p>
         * The scope of projects to be selected for scanning within the integrated repositories. Setting the value to
         * <code>ALL</code> applies the scope settings to all existing and future projects imported into Amazon
         * Inspector.
         * </p>
         * 
         * @param projectSelectionScope
         *        The scope of projects to be selected for scanning within the integrated repositories. Setting the
         *        value to <code>ALL</code> applies the scope settings to all existing and future projects imported into
         *        Amazon Inspector.
         * @see ProjectSelectionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectSelectionScope
         */
        Builder projectSelectionScope(ProjectSelectionScope projectSelectionScope);
    }

    static final class BuilderImpl implements Builder {
        private String projectSelectionScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeSettings model) {
            projectSelectionScope(model.projectSelectionScope);
        }

        public final String getProjectSelectionScope() {
            return projectSelectionScope;
        }

        public final void setProjectSelectionScope(String projectSelectionScope) {
            this.projectSelectionScope = projectSelectionScope;
        }

        @Override
        public final Builder projectSelectionScope(String projectSelectionScope) {
            this.projectSelectionScope = projectSelectionScope;
            return this;
        }

        @Override
        public final Builder projectSelectionScope(ProjectSelectionScope projectSelectionScope) {
            this.projectSelectionScope(projectSelectionScope == null ? null : projectSelectionScope.toString());
            return this;
        }

        @Override
        public ScopeSettings build() {
            return new ScopeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
