/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCodeSecurityIntegrationRequest extends Inspector2Request implements
        ToCopyableBuilder<UpdateCodeSecurityIntegrationRequest.Builder, UpdateCodeSecurityIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationArn").getter(getter(UpdateCodeSecurityIntegrationRequest::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()).build();

    private static final SdkField<UpdateIntegrationDetails> DETAILS_FIELD = SdkField
            .<UpdateIntegrationDetails> builder(MarshallingType.SDK_POJO).memberName("details")
            .getter(getter(UpdateCodeSecurityIntegrationRequest::details)).setter(setter(Builder::details))
            .constructor(UpdateIntegrationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD,
            DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationArn;

    private final UpdateIntegrationDetails details;

    private UpdateCodeSecurityIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationArn = builder.integrationArn;
        this.details = builder.details;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the code security integration to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the code security integration to update.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The updated integration details specific to the repository provider type.
     * </p>
     * 
     * @return The updated integration details specific to the repository provider type.
     */
    public final UpdateIntegrationDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCodeSecurityIntegrationRequest)) {
            return false;
        }
        UpdateCodeSecurityIntegrationRequest other = (UpdateCodeSecurityIntegrationRequest) obj;
        return Objects.equals(integrationArn(), other.integrationArn()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCodeSecurityIntegrationRequest").add("IntegrationArn", integrationArn())
                .add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCodeSecurityIntegrationRequest, T> g) {
        return obj -> g.apply((UpdateCodeSecurityIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCodeSecurityIntegrationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the code security integration to update.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the code security integration to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The updated integration details specific to the repository provider type.
         * </p>
         * 
         * @param details
         *        The updated integration details specific to the repository provider type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(UpdateIntegrationDetails details);

        /**
         * <p>
         * The updated integration details specific to the repository provider type.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateIntegrationDetails.Builder}
         * avoiding the need to create one manually via {@link UpdateIntegrationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateIntegrationDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #details(UpdateIntegrationDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link UpdateIntegrationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(UpdateIntegrationDetails)
         */
        default Builder details(Consumer<UpdateIntegrationDetails.Builder> details) {
            return details(UpdateIntegrationDetails.builder().applyMutation(details).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String integrationArn;

        private UpdateIntegrationDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCodeSecurityIntegrationRequest model) {
            super(model);
            integrationArn(model.integrationArn);
            details(model.details);
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final UpdateIntegrationDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(UpdateIntegrationDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(UpdateIntegrationDetails details) {
            this.details = details;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCodeSecurityIntegrationRequest build() {
            return new UpdateCodeSecurityIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
