/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspectorscan;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.inspectorscan.model.AccessDeniedException;
import software.amazon.awssdk.services.inspectorscan.model.InspectorScanException;
import software.amazon.awssdk.services.inspectorscan.model.InternalServerException;
import software.amazon.awssdk.services.inspectorscan.model.ScanSbomRequest;
import software.amazon.awssdk.services.inspectorscan.model.ScanSbomResponse;
import software.amazon.awssdk.services.inspectorscan.model.ThrottlingException;
import software.amazon.awssdk.services.inspectorscan.model.ValidationException;

/**
 * Service client for accessing inspector-scan. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Inspector Scan is a vulnerability discovery service that scans a provided Software Bill of Materials (SBOM)
 * for security vulnerabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface InspectorScanClient extends AwsClient {
    String SERVICE_NAME = "inspector-scan";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "inspector-scan";

    /**
     * <p>
     * Scans a provided CycloneDX 1.5 SBOM and reports on any vulnerabilities discovered in that SBOM. You can generate
     * compatible SBOMs for your resources using the <a href="">Amazon Inspector SBOM generator</a>.
     * </p>
     *
     * @param scanSbomRequest
     * @return Result of the ScanSbom operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorScanException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorScanClient.ScanSbom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-scan-2023-08-08/ScanSbom" target="_top">AWS API
     *      Documentation</a>
     */
    default ScanSbomResponse scanSbom(ScanSbomRequest scanSbomRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, InspectorScanException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Scans a provided CycloneDX 1.5 SBOM and reports on any vulnerabilities discovered in that SBOM. You can generate
     * compatible SBOMs for your resources using the <a href="">Amazon Inspector SBOM generator</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScanSbomRequest.Builder} avoiding the need to
     * create one manually via {@link ScanSbomRequest#builder()}
     * </p>
     *
     * @param scanSbomRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.inspectorscan.model.ScanSbomRequest.Builder} to create a request.
     * @return Result of the ScanSbom operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation due to missing required fields or having invalid inputs.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorScanException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorScanClient.ScanSbom
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector-scan-2023-08-08/ScanSbom" target="_top">AWS API
     *      Documentation</a>
     */
    default ScanSbomResponse scanSbom(Consumer<ScanSbomRequest.Builder> scanSbomRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            InspectorScanException {
        return scanSbom(ScanSbomRequest.builder().applyMutation(scanSbomRequest).build());
    }

    /**
     * Create a {@link InspectorScanClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static InspectorScanClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link InspectorScanClient}.
     */
    static InspectorScanClientBuilder builder() {
        return new DefaultInspectorScanClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default InspectorScanServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
