/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspectorscan.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanSbomRequest extends InspectorScanRequest implements
        ToCopyableBuilder<ScanSbomRequest.Builder, ScanSbomRequest> {
    private static final SdkField<Document> SBOM_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("sbom")
            .getter(getter(ScanSbomRequest::sbom)).setter(setter(Builder::sbom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputFormat").getter(getter(ScanSbomRequest::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SBOM_FIELD,
            OUTPUT_FORMAT_FIELD));

    private final Document sbom;

    private final String outputFormat;

    private ScanSbomRequest(BuilderImpl builder) {
        super(builder);
        this.sbom = builder.sbom;
        this.outputFormat = builder.outputFormat;
    }

    /**
     * <p>
     * The JSON file for the SBOM you want to scan. The SBOM must be in CycloneDX 1.5 format.
     * </p>
     * 
     * @return The JSON file for the SBOM you want to scan. The SBOM must be in CycloneDX 1.5 format.
     */
    public final Document sbom() {
        return sbom;
    }

    /**
     * <p>
     * The output format for the vulnerability report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format for the vulnerability report.
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The output format for the vulnerability report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The output format for the vulnerability report.
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sbom());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanSbomRequest)) {
            return false;
        }
        ScanSbomRequest other = (ScanSbomRequest) obj;
        return Objects.equals(sbom(), other.sbom()) && Objects.equals(outputFormatAsString(), other.outputFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanSbomRequest").add("Sbom", sbom()).add("OutputFormat", outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sbom":
            return Optional.ofNullable(clazz.cast(sbom()));
        case "outputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanSbomRequest, T> g) {
        return obj -> g.apply((ScanSbomRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorScanRequest.Builder, SdkPojo, CopyableBuilder<Builder, ScanSbomRequest> {
        /**
         * <p>
         * The JSON file for the SBOM you want to scan. The SBOM must be in CycloneDX 1.5 format.
         * </p>
         * 
         * @param sbom
         *        The JSON file for the SBOM you want to scan. The SBOM must be in CycloneDX 1.5 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sbom(Document sbom);

        /**
         * <p>
         * The output format for the vulnerability report.
         * </p>
         * 
         * @param outputFormat
         *        The output format for the vulnerability report.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The output format for the vulnerability report.
         * </p>
         * 
         * @param outputFormat
         *        The output format for the vulnerability report.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorScanRequest.BuilderImpl implements Builder {
        private Document sbom;

        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanSbomRequest model) {
            super(model);
            sbom(model.sbom);
            outputFormat(model.outputFormat);
        }

        public final Document getSbom() {
            return sbom;
        }

        public final void setSbom(Document sbom) {
            this.sbom = sbom;
        }

        @Override
        public final Builder sbom(Document sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ScanSbomRequest build() {
            return new ScanSbomRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
