/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for other locations that you choose to publish Amazon CloudWatch Internet Monitor internet
 * measurements to, such as Amazon S3. The measurements are also published to Amazon CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternetMeasurementsLogDelivery implements SdkPojo, Serializable,
        ToCopyableBuilder<InternetMeasurementsLogDelivery.Builder, InternetMeasurementsLogDelivery> {
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("S3Config").getter(getter(InternetMeasurementsLogDelivery::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Config s3Config;

    private InternetMeasurementsLogDelivery(BuilderImpl builder) {
        this.s3Config = builder.s3Config;
    }

    /**
     * <p>
     * The configuration information for publishing Internet Monitor internet measurements to Amazon S3. The
     * configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements, and
     * the delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on whether
     * you choose to deliver internet measurements to S3 logs.
     * </p>
     * 
     * @return The configuration information for publishing Internet Monitor internet measurements to Amazon S3. The
     *         configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the
     *         measurements, and the delivery status. The delivery status is <code>ENABLED</code> or
     *         <code>DISABLED</code>, depending on whether you choose to deliver internet measurements to S3 logs.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetMeasurementsLogDelivery)) {
            return false;
        }
        InternetMeasurementsLogDelivery other = (InternetMeasurementsLogDelivery) obj;
        return Objects.equals(s3Config(), other.s3Config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InternetMeasurementsLogDelivery").add("S3Config", s3Config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InternetMeasurementsLogDelivery, T> g) {
        return obj -> g.apply((InternetMeasurementsLogDelivery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternetMeasurementsLogDelivery> {
        /**
         * <p>
         * The configuration information for publishing Internet Monitor internet measurements to Amazon S3. The
         * configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements,
         * and the delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on
         * whether you choose to deliver internet measurements to S3 logs.
         * </p>
         * 
         * @param s3Config
         *        The configuration information for publishing Internet Monitor internet measurements to Amazon S3. The
         *        configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the
         *        measurements, and the delivery status. The delivery status is <code>ENABLED</code> or
         *        <code>DISABLED</code>, depending on whether you choose to deliver internet measurements to S3 logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * <p>
         * The configuration information for publishing Internet Monitor internet measurements to Amazon S3. The
         * configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements,
         * and the delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on
         * whether you choose to deliver internet measurements to S3 logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Config s3Config;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetMeasurementsLogDelivery model) {
            s3Config(model.s3Config);
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        @Override
        public InternetMeasurementsLogDelivery build() {
            return new InternetMeasurementsLogDelivery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
