/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Internet health includes measurements calculated by Amazon CloudWatch Internet Monitor about the performance and
 * availability for your application on the internet. Amazon Web Services has substantial historical data about internet
 * performance and availability between Amazon Web Services services and different network providers and geographies. By
 * applying statistical analysis to the data, Internet Monitor can detect when the performance and availability for your
 * application has dropped, compared to an estimated baseline that's already calculated. To make it easier to see those
 * drops, Internet Monitor reports the information to you in the form of health scores: a performance score and an
 * availability score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternetHealth implements SdkPojo, Serializable, ToCopyableBuilder<InternetHealth.Builder, InternetHealth> {
    private static final SdkField<AvailabilityMeasurement> AVAILABILITY_FIELD = SdkField
            .<AvailabilityMeasurement> builder(MarshallingType.SDK_POJO).memberName("Availability")
            .getter(getter(InternetHealth::availability)).setter(setter(Builder::availability))
            .constructor(AvailabilityMeasurement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Availability").build()).build();

    private static final SdkField<PerformanceMeasurement> PERFORMANCE_FIELD = SdkField
            .<PerformanceMeasurement> builder(MarshallingType.SDK_POJO).memberName("Performance")
            .getter(getter(InternetHealth::performance)).setter(setter(Builder::performance))
            .constructor(PerformanceMeasurement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Performance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_FIELD,
            PERFORMANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AvailabilityMeasurement availability;

    private final PerformanceMeasurement performance;

    private InternetHealth(BuilderImpl builder) {
        this.availability = builder.availability;
        this.performance = builder.performance;
    }

    /**
     * <p>
     * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an
     * availability drop. For example, an availability score of 99% for an end user and service location pair is
     * equivalent to 1% of the traffic experiencing an availability drop for that pair.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
     * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet
     * Monitor section of the <i>CloudWatch User Guide</i>.
     * </p>
     * 
     * @return Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an
     *         availability drop. For example, an availability score of 99% for an end user and service location pair is
     *         equivalent to 1% of the traffic experiencing an availability drop for that pair.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
     *         >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch
     *         Internet Monitor section of the <i>CloudWatch User Guide</i>.
     */
    public final AvailabilityMeasurement availability() {
        return availability;
    }

    /**
     * <p>
     * Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a performance
     * drop. For example, a performance score of 99% for an end user and service location pair is equivalent to 1% of
     * the traffic experiencing a performance drop for that pair.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
     * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet
     * Monitor section of the <i>CloudWatch User Guide</i>.
     * </p>
     * 
     * @return Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a
     *         performance drop. For example, a performance score of 99% for an end user and service location pair is
     *         equivalent to 1% of the traffic experiencing a performance drop for that pair.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
     *         >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch
     *         Internet Monitor section of the <i>CloudWatch User Guide</i>.
     */
    public final PerformanceMeasurement performance() {
        return performance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availability());
        hashCode = 31 * hashCode + Objects.hashCode(performance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetHealth)) {
            return false;
        }
        InternetHealth other = (InternetHealth) obj;
        return Objects.equals(availability(), other.availability()) && Objects.equals(performance(), other.performance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InternetHealth").add("Availability", availability()).add("Performance", performance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Availability":
            return Optional.ofNullable(clazz.cast(availability()));
        case "Performance":
            return Optional.ofNullable(clazz.cast(performance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InternetHealth, T> g) {
        return obj -> g.apply((InternetHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternetHealth> {
        /**
         * <p>
         * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an
         * availability drop. For example, an availability score of 99% for an end user and service location pair is
         * equivalent to 1% of the traffic experiencing an availability drop for that pair.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet
         * Monitor section of the <i>CloudWatch User Guide</i>.
         * </p>
         * 
         * @param availability
         *        Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an
         *        availability drop. For example, an availability score of 99% for an end user and service location pair
         *        is equivalent to 1% of the traffic experiencing an availability drop for that pair.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         *        >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch
         *        Internet Monitor section of the <i>CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availability(AvailabilityMeasurement availability);

        /**
         * <p>
         * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an
         * availability drop. For example, an availability score of 99% for an end user and service location pair is
         * equivalent to 1% of the traffic experiencing an availability drop for that pair.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet
         * Monitor section of the <i>CloudWatch User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailabilityMeasurement.Builder} avoiding
         * the need to create one manually via {@link AvailabilityMeasurement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailabilityMeasurement.Builder#build()} is called immediately
         * and its result is passed to {@link #availability(AvailabilityMeasurement)}.
         * 
         * @param availability
         *        a consumer that will call methods on {@link AvailabilityMeasurement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availability(AvailabilityMeasurement)
         */
        default Builder availability(Consumer<AvailabilityMeasurement.Builder> availability) {
            return availability(AvailabilityMeasurement.builder().applyMutation(availability).build());
        }

        /**
         * <p>
         * Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a
         * performance drop. For example, a performance score of 99% for an end user and service location pair is
         * equivalent to 1% of the traffic experiencing a performance drop for that pair.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet
         * Monitor section of the <i>CloudWatch User Guide</i>.
         * </p>
         * 
         * @param performance
         *        Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a
         *        performance drop. For example, a performance score of 99% for an end user and service location pair is
         *        equivalent to 1% of the traffic experiencing a performance drop for that pair.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         *        >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch
         *        Internet Monitor section of the <i>CloudWatch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performance(PerformanceMeasurement performance);

        /**
         * <p>
         * Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a
         * performance drop. For example, a performance score of 99% for an end user and service location pair is
         * equivalent to 1% of the traffic experiencing a performance drop for that pair.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores"
         * >How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet
         * Monitor section of the <i>CloudWatch User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceMeasurement.Builder} avoiding
         * the need to create one manually via {@link PerformanceMeasurement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceMeasurement.Builder#build()} is called immediately and
         * its result is passed to {@link #performance(PerformanceMeasurement)}.
         * 
         * @param performance
         *        a consumer that will call methods on {@link PerformanceMeasurement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performance(PerformanceMeasurement)
         */
        default Builder performance(Consumer<PerformanceMeasurement.Builder> performance) {
            return performance(PerformanceMeasurement.builder().applyMutation(performance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AvailabilityMeasurement availability;

        private PerformanceMeasurement performance;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetHealth model) {
            availability(model.availability);
            performance(model.performance);
        }

        public final AvailabilityMeasurement.Builder getAvailability() {
            return availability != null ? availability.toBuilder() : null;
        }

        public final void setAvailability(AvailabilityMeasurement.BuilderImpl availability) {
            this.availability = availability != null ? availability.build() : null;
        }

        @Override
        public final Builder availability(AvailabilityMeasurement availability) {
            this.availability = availability;
            return this;
        }

        public final PerformanceMeasurement.Builder getPerformance() {
            return performance != null ? performance.toBuilder() : null;
        }

        public final void setPerformance(PerformanceMeasurement.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        public final Builder performance(PerformanceMeasurement performance) {
            this.performance = performance;
            return this;
        }

        @Override
        public InternetHealth build() {
            return new InternetHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
