/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InternetEventStatus {
    ACTIVE("ACTIVE"),
    RESOLVED("RESOLVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InternetEventStatus> VALUE_MAP;
    private final String value;

    private InternetEventStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InternetEventStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InternetEventStatus> knownValues() {
        EnumSet<InternetEventStatus> knownValues = EnumSet.allOf(InternetEventStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InternetEventStatus.class, InternetEventStatus::toString);
    }
}

