/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.QueryDataCopier;
import software.amazon.awssdk.services.internetmonitor.model.QueryField;
import software.amazon.awssdk.services.internetmonitor.model.QueryFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsResponse
extends InternetMonitorResponse
implements ToCopyableBuilder<Builder, GetQueryResultsResponse> {
    private static final SdkField<List<QueryField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::fields)).setter(GetQueryResultsResponse.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Data").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::data)).setter(GetQueryResultsResponse.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::nextToken)).setter(GetQueryResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, DATA_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Fields", FIELDS_FIELD);
            this.put("Data", DATA_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<QueryField> fields;
    private final List<List<String>> data;
    private final String nextToken;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.fields = builder.fields;
        this.data = builder.data;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<QueryField> fields() {
        return this.fields;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructList);
    }

    public final List<List<String>> data() {
        return this.data;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse)((Object)obj);
        return this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsResponse").add("Fields", this.hasFields() ? this.fields() : null).add("Data", this.hasData() ? this.data() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorResponse.BuilderImpl
    implements Builder {
        private List<QueryField> fields = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> data = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            this.fields(model.fields);
            this.data(model.data);
            this.nextToken(model.nextToken);
        }

        public final List<QueryField.Builder> getFields() {
            List<QueryField.Builder> result = QueryFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<QueryField.BuilderImpl> fields) {
            this.fields = QueryFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<QueryField> fields) {
            this.fields = QueryFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(QueryField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<QueryField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (QueryField)((QueryField.Builder)QueryField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Collection<String>> getData() {
            if (this.data instanceof SdkAutoConstructList) {
                return null;
            }
            return this.data;
        }

        public final void setData(Collection<? extends Collection<String>> data) {
            this.data = QueryDataCopier.copy(data);
        }

        @Override
        public final Builder data(Collection<? extends Collection<String>> data) {
            this.data = QueryDataCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Collection<String> ... data) {
            this.data((Collection<? extends Collection<String>>)Arrays.asList(data));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InternetMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsResponse> {
        public Builder fields(Collection<QueryField> var1);

        public Builder fields(QueryField ... var1);

        public Builder fields(Consumer<QueryField.Builder> ... var1);

        public Builder data(Collection<? extends Collection<String>> var1);

        public Builder data(Collection<String> ... var1);

        public Builder nextToken(String var1);
    }
}

