/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The impacted location, such as a city, that Amazon Web Services clients access application resources from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientLocation implements SdkPojo, Serializable, ToCopyableBuilder<ClientLocation.Builder, ClientLocation> {
    private static final SdkField<String> AS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ASName")
            .getter(getter(ClientLocation::asName)).setter(setter(Builder::asName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASName").build()).build();

    private static final SdkField<Long> AS_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ASNumber")
            .getter(getter(ClientLocation::asNumber)).setter(setter(Builder::asNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASNumber").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(ClientLocation::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> SUBDIVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdivision").getter(getter(ClientLocation::subdivision)).setter(setter(Builder::subdivision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdivision").build()).build();

    private static final SdkField<String> METRO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metro")
            .getter(getter(ClientLocation::metro)).setter(setter(Builder::metro))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metro").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(ClientLocation::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<Double> LATITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Latitude").getter(getter(ClientLocation::latitude)).setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latitude").build()).build();

    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Longitude").getter(getter(ClientLocation::longitude)).setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Longitude").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AS_NAME_FIELD,
            AS_NUMBER_FIELD, COUNTRY_FIELD, SUBDIVISION_FIELD, METRO_FIELD, CITY_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ASName", AS_NAME_FIELD);
                    put("ASNumber", AS_NUMBER_FIELD);
                    put("Country", COUNTRY_FIELD);
                    put("Subdivision", SUBDIVISION_FIELD);
                    put("Metro", METRO_FIELD);
                    put("City", CITY_FIELD);
                    put("Latitude", LATITUDE_FIELD);
                    put("Longitude", LONGITUDE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String asName;

    private final Long asNumber;

    private final String country;

    private final String subdivision;

    private final String metro;

    private final String city;

    private final Double latitude;

    private final Double longitude;

    private ClientLocation(BuilderImpl builder) {
        this.asName = builder.asName;
        this.asNumber = builder.asNumber;
        this.country = builder.country;
        this.subdivision = builder.subdivision;
        this.metro = builder.metro;
        this.city = builder.city;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * The name of the internet service provider (ISP) or network (ASN).
     * </p>
     * 
     * @return The name of the internet service provider (ISP) or network (ASN).
     */
    public final String asName() {
        return asName;
    }

    /**
     * <p>
     * The Autonomous System Number (ASN) of the network at an impacted location.
     * </p>
     * 
     * @return The Autonomous System Number (ASN) of the network at an impacted location.
     */
    public final Long asNumber() {
        return asNumber;
    }

    /**
     * <p>
     * The name of the country where the internet event is located.
     * </p>
     * 
     * @return The name of the country where the internet event is located.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The subdivision location where the health event is located. The subdivision usually maps to states in most
     * countries (including the United States). For United Kingdom, it maps to a country (England, Scotland, Wales) or
     * province (Northern Ireland).
     * </p>
     * 
     * @return The subdivision location where the health event is located. The subdivision usually maps to states in
     *         most countries (including the United States). For United Kingdom, it maps to a country (England,
     *         Scotland, Wales) or province (Northern Ireland).
     */
    public final String subdivision() {
        return subdivision;
    }

    /**
     * <p>
     * The metro area where the health event is located.
     * </p>
     * <p>
     * Metro indicates a metropolitan region in the United States, such as the region around New York City. In non-US
     * countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a county, a London
     * borough, a unitary authority, council area, and so on.
     * </p>
     * 
     * @return The metro area where the health event is located.</p>
     *         <p>
     *         Metro indicates a metropolitan region in the United States, such as the region around New York City. In
     *         non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a
     *         county, a London borough, a unitary authority, council area, and so on.
     */
    public final String metro() {
        return metro;
    }

    /**
     * <p>
     * The name of the city where the internet event is located.
     * </p>
     * 
     * @return The name of the city where the internet event is located.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The latitude where the internet event is located.
     * </p>
     * 
     * @return The latitude where the internet event is located.
     */
    public final Double latitude() {
        return latitude;
    }

    /**
     * <p>
     * The longitude where the internet event is located.
     * </p>
     * 
     * @return The longitude where the internet event is located.
     */
    public final Double longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asName());
        hashCode = 31 * hashCode + Objects.hashCode(asNumber());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(subdivision());
        hashCode = 31 * hashCode + Objects.hashCode(metro());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientLocation)) {
            return false;
        }
        ClientLocation other = (ClientLocation) obj;
        return Objects.equals(asName(), other.asName()) && Objects.equals(asNumber(), other.asNumber())
                && Objects.equals(country(), other.country()) && Objects.equals(subdivision(), other.subdivision())
                && Objects.equals(metro(), other.metro()) && Objects.equals(city(), other.city())
                && Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientLocation").add("ASName", asName()).add("ASNumber", asNumber()).add("Country", country())
                .add("Subdivision", subdivision()).add("Metro", metro()).add("City", city()).add("Latitude", latitude())
                .add("Longitude", longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ASName":
            return Optional.ofNullable(clazz.cast(asName()));
        case "ASNumber":
            return Optional.ofNullable(clazz.cast(asNumber()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Subdivision":
            return Optional.ofNullable(clazz.cast(subdivision()));
        case "Metro":
            return Optional.ofNullable(clazz.cast(metro()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "Longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClientLocation, T> g) {
        return obj -> g.apply((ClientLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientLocation> {
        /**
         * <p>
         * The name of the internet service provider (ISP) or network (ASN).
         * </p>
         * 
         * @param asName
         *        The name of the internet service provider (ISP) or network (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asName(String asName);

        /**
         * <p>
         * The Autonomous System Number (ASN) of the network at an impacted location.
         * </p>
         * 
         * @param asNumber
         *        The Autonomous System Number (ASN) of the network at an impacted location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asNumber(Long asNumber);

        /**
         * <p>
         * The name of the country where the internet event is located.
         * </p>
         * 
         * @param country
         *        The name of the country where the internet event is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The subdivision location where the health event is located. The subdivision usually maps to states in most
         * countries (including the United States). For United Kingdom, it maps to a country (England, Scotland, Wales)
         * or province (Northern Ireland).
         * </p>
         * 
         * @param subdivision
         *        The subdivision location where the health event is located. The subdivision usually maps to states in
         *        most countries (including the United States). For United Kingdom, it maps to a country (England,
         *        Scotland, Wales) or province (Northern Ireland).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivision(String subdivision);

        /**
         * <p>
         * The metro area where the health event is located.
         * </p>
         * <p>
         * Metro indicates a metropolitan region in the United States, such as the region around New York City. In
         * non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a
         * county, a London borough, a unitary authority, council area, and so on.
         * </p>
         * 
         * @param metro
         *        The metro area where the health event is located.</p>
         *        <p>
         *        Metro indicates a metropolitan region in the United States, such as the region around New York City.
         *        In non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could
         *        be a county, a London borough, a unitary authority, council area, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metro(String metro);

        /**
         * <p>
         * The name of the city where the internet event is located.
         * </p>
         * 
         * @param city
         *        The name of the city where the internet event is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The latitude where the internet event is located.
         * </p>
         * 
         * @param latitude
         *        The latitude where the internet event is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(Double latitude);

        /**
         * <p>
         * The longitude where the internet event is located.
         * </p>
         * 
         * @param longitude
         *        The longitude where the internet event is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(Double longitude);
    }

    static final class BuilderImpl implements Builder {
        private String asName;

        private Long asNumber;

        private String country;

        private String subdivision;

        private String metro;

        private String city;

        private Double latitude;

        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientLocation model) {
            asName(model.asName);
            asNumber(model.asNumber);
            country(model.country);
            subdivision(model.subdivision);
            metro(model.metro);
            city(model.city);
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final String getAsName() {
            return asName;
        }

        public final void setAsName(String asName) {
            this.asName = asName;
        }

        @Override
        public final Builder asName(String asName) {
            this.asName = asName;
            return this;
        }

        public final Long getAsNumber() {
            return asNumber;
        }

        public final void setAsNumber(Long asNumber) {
            this.asNumber = asNumber;
        }

        @Override
        public final Builder asNumber(Long asNumber) {
            this.asNumber = asNumber;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getSubdivision() {
            return subdivision;
        }

        public final void setSubdivision(String subdivision) {
            this.subdivision = subdivision;
        }

        @Override
        public final Builder subdivision(String subdivision) {
            this.subdivision = subdivision;
            return this;
        }

        public final String getMetro() {
            return metro;
        }

        public final void setMetro(String metro) {
            this.metro = metro;
        }

        @Override
        public final Builder metro(String metro) {
            this.metro = metro;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final Double getLatitude() {
            return latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public ClientLocation build() {
            return new ClientLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
