/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHealthEventsRequest extends InternetMonitorRequest implements
        ToCopyableBuilder<ListHealthEventsRequest.Builder, ListHealthEventsRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(ListHealthEventsRequest::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MonitorName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(ListHealthEventsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(ListHealthEventsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHealthEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListHealthEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventStatus").getter(getter(ListHealthEventsRequest::eventStatusAsString))
            .setter(setter(Builder::eventStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EventStatus").build()).build();

    private static final SdkField<String> LINKED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkedAccountId").getter(getter(ListHealthEventsRequest::linkedAccountId))
            .setter(setter(Builder::linkedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LinkedAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, EVENT_STATUS_FIELD, LINKED_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorName;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final Integer maxResults;

    private final String eventStatus;

    private final String linkedAccountId;

    private ListHealthEventsRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.eventStatus = builder.eventStatus;
        this.linkedAccountId = builder.linkedAccountId;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The time when a health event started.
     * </p>
     * 
     * @return The time when a health event started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when a health event ended. If the health event is still ongoing, then the end time is not set.
     * </p>
     * 
     * @return The time when a health event ended. If the health event is still ongoing, then the end time is not set.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of health event objects that you want to return with this call.
     * </p>
     * 
     * @return The number of health event objects that you want to return with this call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The status of a health event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link HealthEventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The status of a health event.
     * @see HealthEventStatus
     */
    public final HealthEventStatus eventStatus() {
        return HealthEventStatus.fromValue(eventStatus);
    }

    /**
     * <p>
     * The status of a health event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link HealthEventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The status of a health event.
     * @see HealthEventStatus
     */
    public final String eventStatusAsString() {
        return eventStatus;
    }

    /**
     * <p>
     * The account ID for an account that you've set up cross-account sharing for in Amazon CloudWatch Internet Monitor.
     * You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor
     * cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.
     * </p>
     * 
     * @return The account ID for an account that you've set up cross-account sharing for in Amazon CloudWatch Internet
     *         Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet
     *         Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.
     */
    public final String linkedAccountId() {
        return linkedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(linkedAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthEventsRequest)) {
            return false;
        }
        ListHealthEventsRequest other = (ListHealthEventsRequest) obj;
        return Objects.equals(monitorName(), other.monitorName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(eventStatusAsString(), other.eventStatusAsString())
                && Objects.equals(linkedAccountId(), other.linkedAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHealthEventsRequest").add("MonitorName", monitorName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("EventStatus", eventStatusAsString()).add("LinkedAccountId", linkedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "EventStatus":
            return Optional.ofNullable(clazz.cast(eventStatusAsString()));
        case "LinkedAccountId":
            return Optional.ofNullable(clazz.cast(linkedAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitorName", MONITOR_NAME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("EventStatus", EVENT_STATUS_FIELD);
        map.put("LinkedAccountId", LINKED_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHealthEventsRequest, T> g) {
        return obj -> g.apply((ListHealthEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InternetMonitorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListHealthEventsRequest> {
        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The time when a health event started.
         * </p>
         * 
         * @param startTime
         *        The time when a health event started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when a health event ended. If the health event is still ongoing, then the end time is not set.
         * </p>
         * 
         * @param endTime
         *        The time when a health event ended. If the health event is still ongoing, then the end time is not
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of health event objects that you want to return with this call.
         * </p>
         * 
         * @param maxResults
         *        The number of health event objects that you want to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The status of a health event.
         * </p>
         * 
         * @param eventStatus
         *        The status of a health event.
         * @see HealthEventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthEventStatus
         */
        Builder eventStatus(String eventStatus);

        /**
         * <p>
         * The status of a health event.
         * </p>
         * 
         * @param eventStatus
         *        The status of a health event.
         * @see HealthEventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthEventStatus
         */
        Builder eventStatus(HealthEventStatus eventStatus);

        /**
         * <p>
         * The account ID for an account that you've set up cross-account sharing for in Amazon CloudWatch Internet
         * Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet
         * Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.
         * </p>
         * 
         * @param linkedAccountId
         *        The account ID for an account that you've set up cross-account sharing for in Amazon CloudWatch
         *        Internet Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access
         *        Manager. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet
         *        Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccountId(String linkedAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InternetMonitorRequest.BuilderImpl implements Builder {
        private String monitorName;

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private Integer maxResults;

        private String eventStatus;

        private String linkedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthEventsRequest model) {
            super(model);
            monitorName(model.monitorName);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            eventStatus(model.eventStatus);
            linkedAccountId(model.linkedAccountId);
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getEventStatus() {
            return eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(HealthEventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getLinkedAccountId() {
            return linkedAccountId;
        }

        public final void setLinkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
        }

        @Override
        public final Builder linkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHealthEventsRequest build() {
            return new ListHealthEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
