/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Round-trip time (RTT) is how long it takes for a request from the user to return a response to the user. Amazon
 * CloudWatch Internet Monitor calculates RTT at different percentiles: p50, p90, and p95.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoundTripTime implements SdkPojo, Serializable, ToCopyableBuilder<RoundTripTime.Builder, RoundTripTime> {
    private static final SdkField<Double> P50_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("P50")
            .getter(getter(RoundTripTime::p50)).setter(setter(Builder::p50))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("P50").build()).build();

    private static final SdkField<Double> P90_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("P90")
            .getter(getter(RoundTripTime::p90)).setter(setter(Builder::p90))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("P90").build()).build();

    private static final SdkField<Double> P95_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("P95")
            .getter(getter(RoundTripTime::p95)).setter(setter(Builder::p95))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("P95").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(P50_FIELD, P90_FIELD,
            P95_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double p50;

    private final Double p90;

    private final Double p95;

    private RoundTripTime(BuilderImpl builder) {
        this.p50 = builder.p50;
        this.p90 = builder.p90;
        this.p95 = builder.p95;
    }

    /**
     * <p>
     * RTT at the 50th percentile (p50).
     * </p>
     * 
     * @return RTT at the 50th percentile (p50).
     */
    public final Double p50() {
        return p50;
    }

    /**
     * <p>
     * RTT at the 90th percentile (p90).
     * </p>
     * 
     * @return RTT at the 90th percentile (p90).
     */
    public final Double p90() {
        return p90;
    }

    /**
     * <p>
     * RTT at the 95th percentile (p95).
     * </p>
     * 
     * @return RTT at the 95th percentile (p95).
     */
    public final Double p95() {
        return p95;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(p50());
        hashCode = 31 * hashCode + Objects.hashCode(p90());
        hashCode = 31 * hashCode + Objects.hashCode(p95());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoundTripTime)) {
            return false;
        }
        RoundTripTime other = (RoundTripTime) obj;
        return Objects.equals(p50(), other.p50()) && Objects.equals(p90(), other.p90()) && Objects.equals(p95(), other.p95());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoundTripTime").add("P50", p50()).add("P90", p90()).add("P95", p95()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "P50":
            return Optional.ofNullable(clazz.cast(p50()));
        case "P90":
            return Optional.ofNullable(clazz.cast(p90()));
        case "P95":
            return Optional.ofNullable(clazz.cast(p95()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("P50", P50_FIELD);
        map.put("P90", P90_FIELD);
        map.put("P95", P95_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoundTripTime, T> g) {
        return obj -> g.apply((RoundTripTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoundTripTime> {
        /**
         * <p>
         * RTT at the 50th percentile (p50).
         * </p>
         * 
         * @param p50
         *        RTT at the 50th percentile (p50).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder p50(Double p50);

        /**
         * <p>
         * RTT at the 90th percentile (p90).
         * </p>
         * 
         * @param p90
         *        RTT at the 90th percentile (p90).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder p90(Double p90);

        /**
         * <p>
         * RTT at the 95th percentile (p95).
         * </p>
         * 
         * @param p95
         *        RTT at the 95th percentile (p95).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder p95(Double p95);
    }

    static final class BuilderImpl implements Builder {
        private Double p50;

        private Double p90;

        private Double p95;

        private BuilderImpl() {
        }

        private BuilderImpl(RoundTripTime model) {
            p50(model.p50);
            p90(model.p90);
            p95(model.p95);
        }

        public final Double getP50() {
            return p50;
        }

        public final void setP50(Double p50) {
            this.p50 = p50;
        }

        @Override
        public final Builder p50(Double p50) {
            this.p50 = p50;
            return this;
        }

        public final Double getP90() {
            return p90;
        }

        public final void setP90(Double p90) {
            this.p90 = p90;
        }

        @Override
        public final Builder p90(Double p90) {
            this.p90 = p90;
            return this;
        }

        public final Double getP95() {
            return p95;
        }

        public final void setP95(Double p95) {
            this.p95 = p95;
        }

        @Override
        public final Builder p95(Double p95) {
            this.p95 = p95;
            return this;
        }

        @Override
        public RoundTripTime build() {
            return new RoundTripTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
