/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvoiceUnitsRequest extends InvoicingRequest implements
        ToCopyableBuilder<ListInvoiceUnitsRequest.Builder, ListInvoiceUnitsRequest> {
    private static final SdkField<Filters> FILTERS_FIELD = SdkField.<Filters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(ListInvoiceUnitsRequest::filters)).setter(setter(Builder::filters))
            .constructor(Filters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvoiceUnitsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInvoiceUnitsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> AS_OF_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("AsOf")
            .getter(getter(ListInvoiceUnitsRequest::asOf)).setter(setter(Builder::asOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsOf").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, AS_OF_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Filters filters;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant asOf;

    private ListInvoiceUnitsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.asOf = builder.asOf;
    }

    /**
     * <p>
     * An optional input to the list API. If multiple filters are specified, the returned list will be a configuration
     * that match all of the provided filters. Supported filter types are <code>InvoiceReceivers</code>,
     * <code>Names</code>, and <code>Accounts</code>.
     * </p>
     * 
     * @return An optional input to the list API. If multiple filters are specified, the returned list will be a
     *         configuration that match all of the provided filters. Supported filter types are
     *         <code>InvoiceReceivers</code>, <code>Names</code>, and <code>Accounts</code>.
     */
    public final Filters filters() {
        return filters;
    }

    /**
     * <p>
     * The next token used to indicate where the returned list should start from.
     * </p>
     * 
     * @return The next token used to indicate where the returned list should start from.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of invoice units that can be returned.
     * </p>
     * 
     * @return The maximum number of invoice units that can be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The state of an invoice unit at a specified time. You can see legacy invoice units that are currently deleted if
     * the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not provided, the default
     * value is the current time.
     * </p>
     * 
     * @return The state of an invoice unit at a specified time. You can see legacy invoice units that are currently
     *         deleted if the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not
     *         provided, the default value is the current time.
     */
    public final Instant asOf() {
        return asOf;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(asOf());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvoiceUnitsRequest)) {
            return false;
        }
        ListInvoiceUnitsRequest other = (ListInvoiceUnitsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(asOf(), other.asOf());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvoiceUnitsRequest").add("Filters", filters()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("AsOf", asOf()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "AsOf":
            return Optional.ofNullable(clazz.cast(asOf()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("AsOf", AS_OF_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvoiceUnitsRequest, T> g) {
        return obj -> g.apply((ListInvoiceUnitsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InvoicingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInvoiceUnitsRequest> {
        /**
         * <p>
         * An optional input to the list API. If multiple filters are specified, the returned list will be a
         * configuration that match all of the provided filters. Supported filter types are
         * <code>InvoiceReceivers</code>, <code>Names</code>, and <code>Accounts</code>.
         * </p>
         * 
         * @param filters
         *        An optional input to the list API. If multiple filters are specified, the returned list will be a
         *        configuration that match all of the provided filters. Supported filter types are
         *        <code>InvoiceReceivers</code>, <code>Names</code>, and <code>Accounts</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filters filters);

        /**
         * <p>
         * An optional input to the list API. If multiple filters are specified, the returned list will be a
         * configuration that match all of the provided filters. Supported filter types are
         * <code>InvoiceReceivers</code>, <code>Names</code>, and <code>Accounts</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filters.Builder} avoiding the need to
         * create one manually via {@link Filters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filters.Builder#build()} is called immediately and its result is
         * passed to {@link #filters(Filters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link Filters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(Filters)
         */
        default Builder filters(Consumer<Filters.Builder> filters) {
            return filters(Filters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The next token used to indicate where the returned list should start from.
         * </p>
         * 
         * @param nextToken
         *        The next token used to indicate where the returned list should start from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of invoice units that can be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of invoice units that can be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The state of an invoice unit at a specified time. You can see legacy invoice units that are currently deleted
         * if the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not provided, the
         * default value is the current time.
         * </p>
         * 
         * @param asOf
         *        The state of an invoice unit at a specified time. You can see legacy invoice units that are currently
         *        deleted if the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not
         *        provided, the default value is the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asOf(Instant asOf);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private Filters filters;

        private String nextToken;

        private Integer maxResults;

        private Instant asOf;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvoiceUnitsRequest model) {
            super(model);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            asOf(model.asOf);
        }

        public final Filters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getAsOf() {
            return asOf;
        }

        public final void setAsOf(Instant asOf) {
            this.asOf = asOf;
        }

        @Override
        public final Builder asOf(Instant asOf) {
            this.asOf = asOf;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInvoiceUnitsRequest build() {
            return new ListInvoiceUnitsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
