/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvoiceUnitsResponse extends InvoicingResponse implements
        ToCopyableBuilder<ListInvoiceUnitsResponse.Builder, ListInvoiceUnitsResponse> {
    private static final SdkField<List<InvoiceUnit>> INVOICE_UNITS_FIELD = SdkField
            .<List<InvoiceUnit>> builder(MarshallingType.LIST)
            .memberName("InvoiceUnits")
            .getter(getter(ListInvoiceUnitsResponse::invoiceUnits))
            .setter(setter(Builder::invoiceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvoiceUnit> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvoiceUnit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvoiceUnitsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNITS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InvoiceUnit> invoiceUnits;

    private final String nextToken;

    private ListInvoiceUnitsResponse(BuilderImpl builder) {
        super(builder);
        this.invoiceUnits = builder.invoiceUnits;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvoiceUnits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvoiceUnits() {
        return invoiceUnits != null && !(invoiceUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvoiceUnits} method.
     * </p>
     * 
     * @return An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
     */
    public final List<InvoiceUnit> invoiceUnits() {
        return invoiceUnits;
    }

    /**
     * <p>
     * The next token used to indicate where the returned list should start from.
     * </p>
     * 
     * @return The next token used to indicate where the returned list should start from.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInvoiceUnits() ? invoiceUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvoiceUnitsResponse)) {
            return false;
        }
        ListInvoiceUnitsResponse other = (ListInvoiceUnitsResponse) obj;
        return hasInvoiceUnits() == other.hasInvoiceUnits() && Objects.equals(invoiceUnits(), other.invoiceUnits())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvoiceUnitsResponse").add("InvoiceUnits", hasInvoiceUnits() ? invoiceUnits() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceUnits":
            return Optional.ofNullable(clazz.cast(invoiceUnits()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceUnits", INVOICE_UNITS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvoiceUnitsResponse, T> g) {
        return obj -> g.apply((ListInvoiceUnitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InvoicingResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInvoiceUnitsResponse> {
        /**
         * <p>
         * An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
         * </p>
         * 
         * @param invoiceUnits
         *        An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnits(Collection<InvoiceUnit> invoiceUnits);

        /**
         * <p>
         * An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
         * </p>
         * 
         * @param invoiceUnits
         *        An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnits(InvoiceUnit... invoiceUnits);

        /**
         * <p>
         * An invoice unit is a set of mutually exclusive accounts that correspond to your business entity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.InvoiceUnit.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.invoicing.model.InvoiceUnit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.InvoiceUnit.Builder#build()} is called immediately and
         * its result is passed to {@link #invoiceUnits(List<InvoiceUnit>)}.
         * 
         * @param invoiceUnits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.InvoiceUnit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invoiceUnits(java.util.Collection<InvoiceUnit>)
         */
        Builder invoiceUnits(Consumer<InvoiceUnit.Builder>... invoiceUnits);

        /**
         * <p>
         * The next token used to indicate where the returned list should start from.
         * </p>
         * 
         * @param nextToken
         *        The next token used to indicate where the returned list should start from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InvoicingResponse.BuilderImpl implements Builder {
        private List<InvoiceUnit> invoiceUnits = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvoiceUnitsResponse model) {
            super(model);
            invoiceUnits(model.invoiceUnits);
            nextToken(model.nextToken);
        }

        public final List<InvoiceUnit.Builder> getInvoiceUnits() {
            List<InvoiceUnit.Builder> result = InvoiceUnitsCopier.copyToBuilder(this.invoiceUnits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvoiceUnits(Collection<InvoiceUnit.BuilderImpl> invoiceUnits) {
            this.invoiceUnits = InvoiceUnitsCopier.copyFromBuilder(invoiceUnits);
        }

        @Override
        public final Builder invoiceUnits(Collection<InvoiceUnit> invoiceUnits) {
            this.invoiceUnits = InvoiceUnitsCopier.copy(invoiceUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceUnits(InvoiceUnit... invoiceUnits) {
            invoiceUnits(Arrays.asList(invoiceUnits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceUnits(Consumer<InvoiceUnit.Builder>... invoiceUnits) {
            invoiceUnits(Stream.of(invoiceUnits).map(c -> InvoiceUnit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvoiceUnitsResponse build() {
            return new ListInvoiceUnitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
