/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.ReceiverAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvoiceProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvoiceProfile> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(InvoiceProfile.getter(InvoiceProfile::accountId)).setter(InvoiceProfile.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> RECEIVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiverName").getter(InvoiceProfile.getter(InvoiceProfile::receiverName)).setter(InvoiceProfile.setter(Builder::receiverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverName").build()}).build();
    private static final SdkField<ReceiverAddress> RECEIVER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReceiverAddress").getter(InvoiceProfile.getter(InvoiceProfile::receiverAddress)).setter(InvoiceProfile.setter(Builder::receiverAddress)).constructor(ReceiverAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverAddress").build()}).build();
    private static final SdkField<String> RECEIVER_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiverEmail").getter(InvoiceProfile.getter(InvoiceProfile::receiverEmail)).setter(InvoiceProfile.setter(Builder::receiverEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverEmail").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(InvoiceProfile.getter(InvoiceProfile::issuer)).setter(InvoiceProfile.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> TAX_REGISTRATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaxRegistrationNumber").getter(InvoiceProfile.getter(InvoiceProfile::taxRegistrationNumber)).setter(InvoiceProfile.setter(Builder::taxRegistrationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxRegistrationNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RECEIVER_NAME_FIELD, RECEIVER_ADDRESS_FIELD, RECEIVER_EMAIL_FIELD, ISSUER_FIELD, TAX_REGISTRATION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvoiceProfile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String receiverName;
    private final ReceiverAddress receiverAddress;
    private final String receiverEmail;
    private final String issuer;
    private final String taxRegistrationNumber;

    private InvoiceProfile(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.receiverName = builder.receiverName;
        this.receiverAddress = builder.receiverAddress;
        this.receiverEmail = builder.receiverEmail;
        this.issuer = builder.issuer;
        this.taxRegistrationNumber = builder.taxRegistrationNumber;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String receiverName() {
        return this.receiverName;
    }

    public final ReceiverAddress receiverAddress() {
        return this.receiverAddress;
    }

    public final String receiverEmail() {
        return this.receiverEmail;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String taxRegistrationNumber() {
        return this.taxRegistrationNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxRegistrationNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceProfile)) {
            return false;
        }
        InvoiceProfile other = (InvoiceProfile)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.receiverName(), other.receiverName()) && Objects.equals(this.receiverAddress(), other.receiverAddress()) && Objects.equals(this.receiverEmail(), other.receiverEmail()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.taxRegistrationNumber(), other.taxRegistrationNumber());
    }

    public final String toString() {
        return ToString.builder((String)"InvoiceProfile").add("AccountId", (Object)this.accountId()).add("ReceiverName", (Object)this.receiverName()).add("ReceiverAddress", (Object)(this.receiverAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("ReceiverEmail", (Object)(this.receiverEmail() == null ? null : "*** Sensitive Data Redacted ***")).add("Issuer", (Object)this.issuer()).add("TaxRegistrationNumber", (Object)(this.taxRegistrationNumber() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ReceiverName": {
                return Optional.ofNullable(clazz.cast(this.receiverName()));
            }
            case "ReceiverAddress": {
                return Optional.ofNullable(clazz.cast(this.receiverAddress()));
            }
            case "ReceiverEmail": {
                return Optional.ofNullable(clazz.cast(this.receiverEmail()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "TaxRegistrationNumber": {
                return Optional.ofNullable(clazz.cast(this.taxRegistrationNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ReceiverName", RECEIVER_NAME_FIELD);
        map.put("ReceiverAddress", RECEIVER_ADDRESS_FIELD);
        map.put("ReceiverEmail", RECEIVER_EMAIL_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("TaxRegistrationNumber", TAX_REGISTRATION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceProfile, T> g) {
        return obj -> g.apply((InvoiceProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String receiverName;
        private ReceiverAddress receiverAddress;
        private String receiverEmail;
        private String issuer;
        private String taxRegistrationNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceProfile model) {
            this.accountId(model.accountId);
            this.receiverName(model.receiverName);
            this.receiverAddress(model.receiverAddress);
            this.receiverEmail(model.receiverEmail);
            this.issuer(model.issuer);
            this.taxRegistrationNumber(model.taxRegistrationNumber);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getReceiverName() {
            return this.receiverName;
        }

        public final void setReceiverName(String receiverName) {
            this.receiverName = receiverName;
        }

        @Override
        public final Builder receiverName(String receiverName) {
            this.receiverName = receiverName;
            return this;
        }

        public final ReceiverAddress.Builder getReceiverAddress() {
            return this.receiverAddress != null ? this.receiverAddress.toBuilder() : null;
        }

        public final void setReceiverAddress(ReceiverAddress.BuilderImpl receiverAddress) {
            this.receiverAddress = receiverAddress != null ? receiverAddress.build() : null;
        }

        @Override
        public final Builder receiverAddress(ReceiverAddress receiverAddress) {
            this.receiverAddress = receiverAddress;
            return this;
        }

        public final String getReceiverEmail() {
            return this.receiverEmail;
        }

        public final void setReceiverEmail(String receiverEmail) {
            this.receiverEmail = receiverEmail;
        }

        @Override
        public final Builder receiverEmail(String receiverEmail) {
            this.receiverEmail = receiverEmail;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getTaxRegistrationNumber() {
            return this.taxRegistrationNumber;
        }

        public final void setTaxRegistrationNumber(String taxRegistrationNumber) {
            this.taxRegistrationNumber = taxRegistrationNumber;
        }

        @Override
        public final Builder taxRegistrationNumber(String taxRegistrationNumber) {
            this.taxRegistrationNumber = taxRegistrationNumber;
            return this;
        }

        public InvoiceProfile build() {
            return new InvoiceProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvoiceProfile> {
        public Builder accountId(String var1);

        public Builder receiverName(String var1);

        public Builder receiverAddress(ReceiverAddress var1);

        default public Builder receiverAddress(Consumer<ReceiverAddress.Builder> receiverAddress) {
            return this.receiverAddress((ReceiverAddress)((ReceiverAddress.Builder)ReceiverAddress.builder().applyMutation(receiverAddress)).build());
        }

        public Builder receiverEmail(String var1);

        public Builder issuer(String var1);

        public Builder taxRegistrationNumber(String var1);
    }
}

