/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CurrencyExchangeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CurrencyExchangeDetails> {
    private static final SdkField<String> SOURCE_CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCurrencyCode").getter(CurrencyExchangeDetails.getter(CurrencyExchangeDetails::sourceCurrencyCode)).setter(CurrencyExchangeDetails.setter(Builder::sourceCurrencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCurrencyCode").build()}).build();
    private static final SdkField<String> TARGET_CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCurrencyCode").getter(CurrencyExchangeDetails.getter(CurrencyExchangeDetails::targetCurrencyCode)).setter(CurrencyExchangeDetails.setter(Builder::targetCurrencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCurrencyCode").build()}).build();
    private static final SdkField<String> RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rate").getter(CurrencyExchangeDetails.getter(CurrencyExchangeDetails::rate)).setter(CurrencyExchangeDetails.setter(Builder::rate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CURRENCY_CODE_FIELD, TARGET_CURRENCY_CODE_FIELD, RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CurrencyExchangeDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceCurrencyCode;
    private final String targetCurrencyCode;
    private final String rate;

    private CurrencyExchangeDetails(BuilderImpl builder) {
        this.sourceCurrencyCode = builder.sourceCurrencyCode;
        this.targetCurrencyCode = builder.targetCurrencyCode;
        this.rate = builder.rate;
    }

    public final String sourceCurrencyCode() {
        return this.sourceCurrencyCode;
    }

    public final String targetCurrencyCode() {
        return this.targetCurrencyCode;
    }

    public final String rate() {
        return this.rate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCurrencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCurrencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.rate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrencyExchangeDetails)) {
            return false;
        }
        CurrencyExchangeDetails other = (CurrencyExchangeDetails)obj;
        return Objects.equals(this.sourceCurrencyCode(), other.sourceCurrencyCode()) && Objects.equals(this.targetCurrencyCode(), other.targetCurrencyCode()) && Objects.equals(this.rate(), other.rate());
    }

    public final String toString() {
        return ToString.builder((String)"CurrencyExchangeDetails").add("SourceCurrencyCode", (Object)this.sourceCurrencyCode()).add("TargetCurrencyCode", (Object)this.targetCurrencyCode()).add("Rate", (Object)this.rate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceCurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.sourceCurrencyCode()));
            }
            case "TargetCurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.targetCurrencyCode()));
            }
            case "Rate": {
                return Optional.ofNullable(clazz.cast(this.rate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SourceCurrencyCode", SOURCE_CURRENCY_CODE_FIELD);
        map.put("TargetCurrencyCode", TARGET_CURRENCY_CODE_FIELD);
        map.put("Rate", RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CurrencyExchangeDetails, T> g) {
        return obj -> g.apply((CurrencyExchangeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceCurrencyCode;
        private String targetCurrencyCode;
        private String rate;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrencyExchangeDetails model) {
            this.sourceCurrencyCode(model.sourceCurrencyCode);
            this.targetCurrencyCode(model.targetCurrencyCode);
            this.rate(model.rate);
        }

        public final String getSourceCurrencyCode() {
            return this.sourceCurrencyCode;
        }

        public final void setSourceCurrencyCode(String sourceCurrencyCode) {
            this.sourceCurrencyCode = sourceCurrencyCode;
        }

        @Override
        public final Builder sourceCurrencyCode(String sourceCurrencyCode) {
            this.sourceCurrencyCode = sourceCurrencyCode;
            return this;
        }

        public final String getTargetCurrencyCode() {
            return this.targetCurrencyCode;
        }

        public final void setTargetCurrencyCode(String targetCurrencyCode) {
            this.targetCurrencyCode = targetCurrencyCode;
        }

        @Override
        public final Builder targetCurrencyCode(String targetCurrencyCode) {
            this.targetCurrencyCode = targetCurrencyCode;
            return this;
        }

        public final String getRate() {
            return this.rate;
        }

        public final void setRate(String rate) {
            this.rate = rate;
        }

        @Override
        public final Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public CurrencyExchangeDetails build() {
            return new CurrencyExchangeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CurrencyExchangeDetails> {
        public Builder sourceCurrencyCode(String var1);

        public Builder targetCurrencyCode(String var1);

        public Builder rate(String var1);
    }
}

