/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.BillingPeriod;
import software.amazon.awssdk.services.invoicing.model.Entity;
import software.amazon.awssdk.services.invoicing.model.InvoiceCurrencyAmount;
import software.amazon.awssdk.services.invoicing.model.InvoiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvoiceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvoiceSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(InvoiceSummary.getter(InvoiceSummary::accountId)).setter(InvoiceSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> INVOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoiceId").getter(InvoiceSummary.getter(InvoiceSummary::invoiceId)).setter(InvoiceSummary.setter(Builder::invoiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceId").build()}).build();
    private static final SdkField<Instant> ISSUED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IssuedDate").getter(InvoiceSummary.getter(InvoiceSummary::issuedDate)).setter(InvoiceSummary.setter(Builder::issuedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedDate").build()}).build();
    private static final SdkField<Instant> DUE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DueDate").getter(InvoiceSummary.getter(InvoiceSummary::dueDate)).setter(InvoiceSummary.setter(Builder::dueDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DueDate").build()}).build();
    private static final SdkField<Entity> ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Entity").getter(InvoiceSummary.getter(InvoiceSummary::entity)).setter(InvoiceSummary.setter(Builder::entity)).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()}).build();
    private static final SdkField<BillingPeriod> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriod").getter(InvoiceSummary.getter(InvoiceSummary::billingPeriod)).setter(InvoiceSummary.setter(Builder::billingPeriod)).constructor(BillingPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<String> INVOICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoiceType").getter(InvoiceSummary.getter(InvoiceSummary::invoiceTypeAsString)).setter(InvoiceSummary.setter(Builder::invoiceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceType").build()}).build();
    private static final SdkField<String> ORIGINAL_INVOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalInvoiceId").getter(InvoiceSummary.getter(InvoiceSummary::originalInvoiceId)).setter(InvoiceSummary.setter(Builder::originalInvoiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalInvoiceId").build()}).build();
    private static final SdkField<String> PURCHASE_ORDER_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseOrderNumber").getter(InvoiceSummary.getter(InvoiceSummary::purchaseOrderNumber)).setter(InvoiceSummary.setter(Builder::purchaseOrderNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderNumber").build()}).build();
    private static final SdkField<InvoiceCurrencyAmount> BASE_CURRENCY_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaseCurrencyAmount").getter(InvoiceSummary.getter(InvoiceSummary::baseCurrencyAmount)).setter(InvoiceSummary.setter(Builder::baseCurrencyAmount)).constructor(InvoiceCurrencyAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseCurrencyAmount").build()}).build();
    private static final SdkField<InvoiceCurrencyAmount> TAX_CURRENCY_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaxCurrencyAmount").getter(InvoiceSummary.getter(InvoiceSummary::taxCurrencyAmount)).setter(InvoiceSummary.setter(Builder::taxCurrencyAmount)).constructor(InvoiceCurrencyAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxCurrencyAmount").build()}).build();
    private static final SdkField<InvoiceCurrencyAmount> PAYMENT_CURRENCY_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PaymentCurrencyAmount").getter(InvoiceSummary.getter(InvoiceSummary::paymentCurrencyAmount)).setter(InvoiceSummary.setter(Builder::paymentCurrencyAmount)).constructor(InvoiceCurrencyAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentCurrencyAmount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, INVOICE_ID_FIELD, ISSUED_DATE_FIELD, DUE_DATE_FIELD, ENTITY_FIELD, BILLING_PERIOD_FIELD, INVOICE_TYPE_FIELD, ORIGINAL_INVOICE_ID_FIELD, PURCHASE_ORDER_NUMBER_FIELD, BASE_CURRENCY_AMOUNT_FIELD, TAX_CURRENCY_AMOUNT_FIELD, PAYMENT_CURRENCY_AMOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvoiceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String invoiceId;
    private final Instant issuedDate;
    private final Instant dueDate;
    private final Entity entity;
    private final BillingPeriod billingPeriod;
    private final String invoiceType;
    private final String originalInvoiceId;
    private final String purchaseOrderNumber;
    private final InvoiceCurrencyAmount baseCurrencyAmount;
    private final InvoiceCurrencyAmount taxCurrencyAmount;
    private final InvoiceCurrencyAmount paymentCurrencyAmount;

    private InvoiceSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.invoiceId = builder.invoiceId;
        this.issuedDate = builder.issuedDate;
        this.dueDate = builder.dueDate;
        this.entity = builder.entity;
        this.billingPeriod = builder.billingPeriod;
        this.invoiceType = builder.invoiceType;
        this.originalInvoiceId = builder.originalInvoiceId;
        this.purchaseOrderNumber = builder.purchaseOrderNumber;
        this.baseCurrencyAmount = builder.baseCurrencyAmount;
        this.taxCurrencyAmount = builder.taxCurrencyAmount;
        this.paymentCurrencyAmount = builder.paymentCurrencyAmount;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String invoiceId() {
        return this.invoiceId;
    }

    public final Instant issuedDate() {
        return this.issuedDate;
    }

    public final Instant dueDate() {
        return this.dueDate;
    }

    public final Entity entity() {
        return this.entity;
    }

    public final BillingPeriod billingPeriod() {
        return this.billingPeriod;
    }

    public final InvoiceType invoiceType() {
        return InvoiceType.fromValue(this.invoiceType);
    }

    public final String invoiceTypeAsString() {
        return this.invoiceType;
    }

    public final String originalInvoiceId() {
        return this.originalInvoiceId;
    }

    public final String purchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public final InvoiceCurrencyAmount baseCurrencyAmount() {
        return this.baseCurrencyAmount;
    }

    public final InvoiceCurrencyAmount taxCurrencyAmount() {
        return this.taxCurrencyAmount;
    }

    public final InvoiceCurrencyAmount paymentCurrencyAmount() {
        return this.paymentCurrencyAmount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dueDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.entity());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalInvoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCurrencyAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxCurrencyAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentCurrencyAmount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceSummary)) {
            return false;
        }
        InvoiceSummary other = (InvoiceSummary)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.invoiceId(), other.invoiceId()) && Objects.equals(this.issuedDate(), other.issuedDate()) && Objects.equals(this.dueDate(), other.dueDate()) && Objects.equals(this.entity(), other.entity()) && Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.invoiceTypeAsString(), other.invoiceTypeAsString()) && Objects.equals(this.originalInvoiceId(), other.originalInvoiceId()) && Objects.equals(this.purchaseOrderNumber(), other.purchaseOrderNumber()) && Objects.equals(this.baseCurrencyAmount(), other.baseCurrencyAmount()) && Objects.equals(this.taxCurrencyAmount(), other.taxCurrencyAmount()) && Objects.equals(this.paymentCurrencyAmount(), other.paymentCurrencyAmount());
    }

    public final String toString() {
        return ToString.builder((String)"InvoiceSummary").add("AccountId", (Object)this.accountId()).add("InvoiceId", (Object)this.invoiceId()).add("IssuedDate", (Object)this.issuedDate()).add("DueDate", (Object)this.dueDate()).add("Entity", (Object)this.entity()).add("BillingPeriod", (Object)this.billingPeriod()).add("InvoiceType", (Object)this.invoiceTypeAsString()).add("OriginalInvoiceId", (Object)this.originalInvoiceId()).add("PurchaseOrderNumber", (Object)this.purchaseOrderNumber()).add("BaseCurrencyAmount", (Object)this.baseCurrencyAmount()).add("TaxCurrencyAmount", (Object)this.taxCurrencyAmount()).add("PaymentCurrencyAmount", (Object)this.paymentCurrencyAmount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "InvoiceId": {
                return Optional.ofNullable(clazz.cast(this.invoiceId()));
            }
            case "IssuedDate": {
                return Optional.ofNullable(clazz.cast(this.issuedDate()));
            }
            case "DueDate": {
                return Optional.ofNullable(clazz.cast(this.dueDate()));
            }
            case "Entity": {
                return Optional.ofNullable(clazz.cast(this.entity()));
            }
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "InvoiceType": {
                return Optional.ofNullable(clazz.cast(this.invoiceTypeAsString()));
            }
            case "OriginalInvoiceId": {
                return Optional.ofNullable(clazz.cast(this.originalInvoiceId()));
            }
            case "PurchaseOrderNumber": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderNumber()));
            }
            case "BaseCurrencyAmount": {
                return Optional.ofNullable(clazz.cast(this.baseCurrencyAmount()));
            }
            case "TaxCurrencyAmount": {
                return Optional.ofNullable(clazz.cast(this.taxCurrencyAmount()));
            }
            case "PaymentCurrencyAmount": {
                return Optional.ofNullable(clazz.cast(this.paymentCurrencyAmount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("InvoiceId", INVOICE_ID_FIELD);
        map.put("IssuedDate", ISSUED_DATE_FIELD);
        map.put("DueDate", DUE_DATE_FIELD);
        map.put("Entity", ENTITY_FIELD);
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("InvoiceType", INVOICE_TYPE_FIELD);
        map.put("OriginalInvoiceId", ORIGINAL_INVOICE_ID_FIELD);
        map.put("PurchaseOrderNumber", PURCHASE_ORDER_NUMBER_FIELD);
        map.put("BaseCurrencyAmount", BASE_CURRENCY_AMOUNT_FIELD);
        map.put("TaxCurrencyAmount", TAX_CURRENCY_AMOUNT_FIELD);
        map.put("PaymentCurrencyAmount", PAYMENT_CURRENCY_AMOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceSummary, T> g) {
        return obj -> g.apply((InvoiceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String invoiceId;
        private Instant issuedDate;
        private Instant dueDate;
        private Entity entity;
        private BillingPeriod billingPeriod;
        private String invoiceType;
        private String originalInvoiceId;
        private String purchaseOrderNumber;
        private InvoiceCurrencyAmount baseCurrencyAmount;
        private InvoiceCurrencyAmount taxCurrencyAmount;
        private InvoiceCurrencyAmount paymentCurrencyAmount;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceSummary model) {
            this.accountId(model.accountId);
            this.invoiceId(model.invoiceId);
            this.issuedDate(model.issuedDate);
            this.dueDate(model.dueDate);
            this.entity(model.entity);
            this.billingPeriod(model.billingPeriod);
            this.invoiceType(model.invoiceType);
            this.originalInvoiceId(model.originalInvoiceId);
            this.purchaseOrderNumber(model.purchaseOrderNumber);
            this.baseCurrencyAmount(model.baseCurrencyAmount);
            this.taxCurrencyAmount(model.taxCurrencyAmount);
            this.paymentCurrencyAmount(model.paymentCurrencyAmount);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getInvoiceId() {
            return this.invoiceId;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final Instant getIssuedDate() {
            return this.issuedDate;
        }

        public final void setIssuedDate(Instant issuedDate) {
            this.issuedDate = issuedDate;
        }

        @Override
        public final Builder issuedDate(Instant issuedDate) {
            this.issuedDate = issuedDate;
            return this;
        }

        public final Instant getDueDate() {
            return this.dueDate;
        }

        public final void setDueDate(Instant dueDate) {
            this.dueDate = dueDate;
        }

        @Override
        public final Builder dueDate(Instant dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public final Entity.Builder getEntity() {
            return this.entity != null ? this.entity.toBuilder() : null;
        }

        public final void setEntity(Entity.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public final BillingPeriod.Builder getBillingPeriod() {
            return this.billingPeriod != null ? this.billingPeriod.toBuilder() : null;
        }

        public final void setBillingPeriod(BillingPeriod.BuilderImpl billingPeriod) {
            this.billingPeriod = billingPeriod != null ? billingPeriod.build() : null;
        }

        @Override
        public final Builder billingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getInvoiceType() {
            return this.invoiceType;
        }

        public final void setInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
        }

        @Override
        public final Builder invoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
            return this;
        }

        @Override
        public final Builder invoiceType(InvoiceType invoiceType) {
            this.invoiceType(invoiceType == null ? null : invoiceType.toString());
            return this;
        }

        public final String getOriginalInvoiceId() {
            return this.originalInvoiceId;
        }

        public final void setOriginalInvoiceId(String originalInvoiceId) {
            this.originalInvoiceId = originalInvoiceId;
        }

        @Override
        public final Builder originalInvoiceId(String originalInvoiceId) {
            this.originalInvoiceId = originalInvoiceId;
            return this;
        }

        public final String getPurchaseOrderNumber() {
            return this.purchaseOrderNumber;
        }

        public final void setPurchaseOrderNumber(String purchaseOrderNumber) {
            this.purchaseOrderNumber = purchaseOrderNumber;
        }

        @Override
        public final Builder purchaseOrderNumber(String purchaseOrderNumber) {
            this.purchaseOrderNumber = purchaseOrderNumber;
            return this;
        }

        public final InvoiceCurrencyAmount.Builder getBaseCurrencyAmount() {
            return this.baseCurrencyAmount != null ? this.baseCurrencyAmount.toBuilder() : null;
        }

        public final void setBaseCurrencyAmount(InvoiceCurrencyAmount.BuilderImpl baseCurrencyAmount) {
            this.baseCurrencyAmount = baseCurrencyAmount != null ? baseCurrencyAmount.build() : null;
        }

        @Override
        public final Builder baseCurrencyAmount(InvoiceCurrencyAmount baseCurrencyAmount) {
            this.baseCurrencyAmount = baseCurrencyAmount;
            return this;
        }

        public final InvoiceCurrencyAmount.Builder getTaxCurrencyAmount() {
            return this.taxCurrencyAmount != null ? this.taxCurrencyAmount.toBuilder() : null;
        }

        public final void setTaxCurrencyAmount(InvoiceCurrencyAmount.BuilderImpl taxCurrencyAmount) {
            this.taxCurrencyAmount = taxCurrencyAmount != null ? taxCurrencyAmount.build() : null;
        }

        @Override
        public final Builder taxCurrencyAmount(InvoiceCurrencyAmount taxCurrencyAmount) {
            this.taxCurrencyAmount = taxCurrencyAmount;
            return this;
        }

        public final InvoiceCurrencyAmount.Builder getPaymentCurrencyAmount() {
            return this.paymentCurrencyAmount != null ? this.paymentCurrencyAmount.toBuilder() : null;
        }

        public final void setPaymentCurrencyAmount(InvoiceCurrencyAmount.BuilderImpl paymentCurrencyAmount) {
            this.paymentCurrencyAmount = paymentCurrencyAmount != null ? paymentCurrencyAmount.build() : null;
        }

        @Override
        public final Builder paymentCurrencyAmount(InvoiceCurrencyAmount paymentCurrencyAmount) {
            this.paymentCurrencyAmount = paymentCurrencyAmount;
            return this;
        }

        public InvoiceSummary build() {
            return new InvoiceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvoiceSummary> {
        public Builder accountId(String var1);

        public Builder invoiceId(String var1);

        public Builder issuedDate(Instant var1);

        public Builder dueDate(Instant var1);

        public Builder entity(Entity var1);

        default public Builder entity(Consumer<Entity.Builder> entity) {
            return this.entity((Entity)((Entity.Builder)Entity.builder().applyMutation(entity)).build());
        }

        public Builder billingPeriod(BillingPeriod var1);

        default public Builder billingPeriod(Consumer<BillingPeriod.Builder> billingPeriod) {
            return this.billingPeriod((BillingPeriod)((BillingPeriod.Builder)BillingPeriod.builder().applyMutation(billingPeriod)).build());
        }

        public Builder invoiceType(String var1);

        public Builder invoiceType(InvoiceType var1);

        public Builder originalInvoiceId(String var1);

        public Builder purchaseOrderNumber(String var1);

        public Builder baseCurrencyAmount(InvoiceCurrencyAmount var1);

        default public Builder baseCurrencyAmount(Consumer<InvoiceCurrencyAmount.Builder> baseCurrencyAmount) {
            return this.baseCurrencyAmount((InvoiceCurrencyAmount)((InvoiceCurrencyAmount.Builder)InvoiceCurrencyAmount.builder().applyMutation(baseCurrencyAmount)).build());
        }

        public Builder taxCurrencyAmount(InvoiceCurrencyAmount var1);

        default public Builder taxCurrencyAmount(Consumer<InvoiceCurrencyAmount.Builder> taxCurrencyAmount) {
            return this.taxCurrencyAmount((InvoiceCurrencyAmount)((InvoiceCurrencyAmount.Builder)InvoiceCurrencyAmount.builder().applyMutation(taxCurrencyAmount)).build());
        }

        public Builder paymentCurrencyAmount(InvoiceCurrencyAmount var1);

        default public Builder paymentCurrencyAmount(Consumer<InvoiceCurrencyAmount.Builder> paymentCurrencyAmount) {
            return this.paymentCurrencyAmount((InvoiceCurrencyAmount)((InvoiceCurrencyAmount.Builder)InvoiceCurrencyAmount.builder().applyMutation(paymentCurrencyAmount)).build());
        }
    }
}

