/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.invoicing.InvoicingAsyncClient;
import software.amazon.awssdk.services.invoicing.internal.UserAgentUtils;
import software.amazon.awssdk.services.invoicing.model.InvoiceSummary;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesResponse;

public class ListInvoiceSummariesPublisher
implements SdkPublisher<ListInvoiceSummariesResponse> {
    private final InvoicingAsyncClient client;
    private final ListInvoiceSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvoiceSummariesPublisher(InvoicingAsyncClient client, ListInvoiceSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvoiceSummariesPublisher(InvoicingAsyncClient client, ListInvoiceSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvoiceSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvoiceSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvoiceSummary> invoiceSummaries() {
        Function<ListInvoiceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.invoiceSummaries() != null) {
                return response.invoiceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvoiceSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvoiceSummariesResponseFetcher
    implements AsyncPageFetcher<ListInvoiceSummariesResponse> {
        private ListInvoiceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListInvoiceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvoiceSummariesResponse> nextPage(ListInvoiceSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListInvoiceSummariesPublisher.this.client.listInvoiceSummaries(ListInvoiceSummariesPublisher.this.firstRequest);
            }
            return ListInvoiceSummariesPublisher.this.client.listInvoiceSummaries((ListInvoiceSummariesRequest)((Object)ListInvoiceSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

