/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.invoicing.model.AccessDeniedException;
import software.amazon.awssdk.services.invoicing.model.BatchGetInvoiceProfileRequest;
import software.amazon.awssdk.services.invoicing.model.BatchGetInvoiceProfileResponse;
import software.amazon.awssdk.services.invoicing.model.CreateInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.CreateInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.DeleteInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.DeleteInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.GetInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.GetInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.InternalServerException;
import software.amazon.awssdk.services.invoicing.model.InvoicingException;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesResponse;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest;
import software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse;
import software.amazon.awssdk.services.invoicing.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.invoicing.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.invoicing.model.ResourceNotFoundException;
import software.amazon.awssdk.services.invoicing.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.invoicing.model.TagResourceRequest;
import software.amazon.awssdk.services.invoicing.model.TagResourceResponse;
import software.amazon.awssdk.services.invoicing.model.ThrottlingException;
import software.amazon.awssdk.services.invoicing.model.UntagResourceRequest;
import software.amazon.awssdk.services.invoicing.model.UntagResourceResponse;
import software.amazon.awssdk.services.invoicing.model.UpdateInvoiceUnitRequest;
import software.amazon.awssdk.services.invoicing.model.UpdateInvoiceUnitResponse;
import software.amazon.awssdk.services.invoicing.model.ValidationException;
import software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable;
import software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable;

/**
 * Service client for accessing AWS Invoicing. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <b>Amazon Web Services Invoice Configuration</b>
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Configuration APIs to programmatically create, update, delete, get, and list
 * invoice units. You can also programmatically fetch the information of the invoice receiver. For example, business
 * legal name, address, and invoicing contacts.
 * </p>
 * <p>
 * You can use Amazon Web Services Invoice Configuration to receive separate Amazon Web Services invoices based your
 * organizational needs. By using Amazon Web Services Invoice Configuration, you can configure invoice units that are
 * groups of Amazon Web Services accounts that represent your business entities, and receive separate invoices for each
 * business entity. You can also assign a unique member or payer account as the invoice receiver for each invoice unit.
 * As you create new accounts within your Organizations using Amazon Web Services Invoice Configuration APIs, you can
 * automate the creation of new invoice units and subsequently automate the addition of new accounts to your invoice
 * units.
 * </p>
 * <p>
 * Service endpoint
 * </p>
 * <p>
 * You can use the following endpoints for Amazon Web Services Invoice Configuration:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>https://invoicing.us-east-1.api.aws</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface InvoicingClient extends AwsClient {
    String SERVICE_NAME = "invoicing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "invoicing";

    /**
     * <p>
     * This gets the invoice profile associated with a set of accounts. The accounts must be linked accounts under the
     * requester management account organization.
     * </p>
     *
     * @param batchGetInvoiceProfileRequest
     * @return Result of the BatchGetInvoiceProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.BatchGetInvoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/BatchGetInvoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetInvoiceProfileResponse batchGetInvoiceProfile(BatchGetInvoiceProfileRequest batchGetInvoiceProfileRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This gets the invoice profile associated with a set of accounts. The accounts must be linked accounts under the
     * requester management account organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetInvoiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetInvoiceProfileRequest#builder()}
     * </p>
     *
     * @param batchGetInvoiceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.BatchGetInvoiceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetInvoiceProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.BatchGetInvoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/BatchGetInvoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetInvoiceProfileResponse batchGetInvoiceProfile(
            Consumer<BatchGetInvoiceProfileRequest.Builder> batchGetInvoiceProfileRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return batchGetInvoiceProfile(BatchGetInvoiceProfileRequest.builder().applyMutation(batchGetInvoiceProfileRequest)
                .build());
    }

    /**
     * <p>
     * This creates a new invoice unit with the provided definition.
     * </p>
     *
     * @param createInvoiceUnitRequest
     * @return Result of the CreateInvoiceUnit operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.CreateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/CreateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInvoiceUnitResponse createInvoiceUnit(CreateInvoiceUnitRequest createInvoiceUnitRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This creates a new invoice unit with the provided definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvoiceUnitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param createInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.CreateInvoiceUnitRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInvoiceUnit operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.CreateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/CreateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInvoiceUnitResponse createInvoiceUnit(Consumer<CreateInvoiceUnitRequest.Builder> createInvoiceUnitRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return createInvoiceUnit(CreateInvoiceUnitRequest.builder().applyMutation(createInvoiceUnitRequest).build());
    }

    /**
     * <p>
     * This deletes an invoice unit with the provided invoice unit ARN.
     * </p>
     *
     * @param deleteInvoiceUnitRequest
     * @return Result of the DeleteInvoiceUnit operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.DeleteInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/DeleteInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvoiceUnitResponse deleteInvoiceUnit(DeleteInvoiceUnitRequest deleteInvoiceUnitRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This deletes an invoice unit with the provided invoice unit ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvoiceUnitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param deleteInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.DeleteInvoiceUnitRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInvoiceUnit operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.DeleteInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/DeleteInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvoiceUnitResponse deleteInvoiceUnit(Consumer<DeleteInvoiceUnitRequest.Builder> deleteInvoiceUnitRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        return deleteInvoiceUnit(DeleteInvoiceUnitRequest.builder().applyMutation(deleteInvoiceUnitRequest).build());
    }

    /**
     * <p>
     * This retrieves the invoice unit definition.
     * </p>
     *
     * @param getInvoiceUnitRequest
     * @return Result of the GetInvoiceUnit operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.GetInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/GetInvoiceUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInvoiceUnitResponse getInvoiceUnit(GetInvoiceUnitRequest getInvoiceUnitRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This retrieves the invoice unit definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvoiceUnitRequest.Builder} avoiding the need to
     * create one manually via {@link GetInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param getInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.GetInvoiceUnitRequest.Builder} to create a request.
     * @return Result of the GetInvoiceUnit operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.GetInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/GetInvoiceUnit" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInvoiceUnitResponse getInvoiceUnit(Consumer<GetInvoiceUnitRequest.Builder> getInvoiceUnitRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        return getInvoiceUnit(GetInvoiceUnitRequest.builder().applyMutation(getInvoiceUnitRequest).build());
    }

    /**
     * <p>
     * Retrieves your invoice details programmatically, without line item details.
     * </p>
     *
     * @param listInvoiceSummariesRequest
     * @return Result of the ListInvoiceSummaries operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvoiceSummariesResponse listInvoiceSummaries(ListInvoiceSummariesRequest listInvoiceSummariesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your invoice details programmatically, without line item details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvoiceSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvoiceSummariesRequest#builder()}
     * </p>
     *
     * @param listInvoiceSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListInvoiceSummaries operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvoiceSummariesResponse listInvoiceSummaries(
            Consumer<ListInvoiceSummariesRequest.Builder> listInvoiceSummariesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return listInvoiceSummaries(ListInvoiceSummariesRequest.builder().applyMutation(listInvoiceSummariesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvoiceSummaries(software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable responses = client.listInvoiceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable responses = client
     *             .listInvoiceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable responses = client.listInvoiceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvoiceSummaries(software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvoiceSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvoiceSummariesIterable listInvoiceSummariesPaginator(ListInvoiceSummariesRequest listInvoiceSummariesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        return new ListInvoiceSummariesIterable(this, listInvoiceSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvoiceSummaries(software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable responses = client.listInvoiceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable responses = client
     *             .listInvoiceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceSummariesIterable responses = client.listInvoiceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvoiceSummaries(software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvoiceSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvoiceSummariesRequest#builder()}
     * </p>
     *
     * @param listInvoiceSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListInvoiceSummariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvoiceSummariesIterable listInvoiceSummariesPaginator(
            Consumer<ListInvoiceSummariesRequest.Builder> listInvoiceSummariesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return listInvoiceSummariesPaginator(ListInvoiceSummariesRequest.builder().applyMutation(listInvoiceSummariesRequest)
                .build());
    }

    /**
     * <p>
     * This fetches a list of all invoice unit definitions for a given account, as of the provided <code>AsOf</code>
     * date.
     * </p>
     *
     * @param listInvoiceUnitsRequest
     * @return Result of the ListInvoiceUnits operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvoiceUnitsResponse listInvoiceUnits(ListInvoiceUnitsRequest listInvoiceUnitsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This fetches a list of all invoice unit definitions for a given account, as of the provided <code>AsOf</code>
     * date.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvoiceUnitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvoiceUnitsRequest#builder()}
     * </p>
     *
     * @param listInvoiceUnitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInvoiceUnits operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvoiceUnitsResponse listInvoiceUnits(Consumer<ListInvoiceUnitsRequest.Builder> listInvoiceUnitsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return listInvoiceUnits(ListInvoiceUnitsRequest.builder().applyMutation(listInvoiceUnitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable responses = client.listInvoiceUnitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable responses = client
     *             .listInvoiceUnitsPaginator(request);
     *     for (software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable responses = client.listInvoiceUnitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation.</b>
     * </p>
     *
     * @param listInvoiceUnitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvoiceUnitsIterable listInvoiceUnitsPaginator(ListInvoiceUnitsRequest listInvoiceUnitsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return new ListInvoiceUnitsIterable(this, listInvoiceUnitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable responses = client.listInvoiceUnitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable responses = client
     *             .listInvoiceUnitsPaginator(request);
     *     for (software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.invoicing.paginators.ListInvoiceUnitsIterable responses = client.listInvoiceUnitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvoiceUnits(software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvoiceUnitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvoiceUnitsRequest#builder()}
     * </p>
     *
     * @param listInvoiceUnitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListInvoiceUnitsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListInvoiceUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListInvoiceUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvoiceUnitsIterable listInvoiceUnitsPaginator(Consumer<ListInvoiceUnitsRequest.Builder> listInvoiceUnitsRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return listInvoiceUnitsPaginator(ListInvoiceUnitsRequest.builder().applyMutation(listInvoiceUnitsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account limits. The error message describes the limit exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account limits. The error message describes the limit exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * You can update the invoice unit configuration at any time, and Amazon Web Services will use the latest
     * configuration at the end of the month.
     * </p>
     *
     * @param updateInvoiceUnitRequest
     * @return Result of the UpdateInvoiceUnit operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.UpdateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UpdateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInvoiceUnitResponse updateInvoiceUnit(UpdateInvoiceUnitRequest updateInvoiceUnitRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can update the invoice unit configuration at any time, and Amazon Web Services will use the latest
     * configuration at the end of the month.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInvoiceUnitRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateInvoiceUnitRequest#builder()}
     * </p>
     *
     * @param updateInvoiceUnitRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.invoicing.model.UpdateInvoiceUnitRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateInvoiceUnit operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The processing request failed because of an unknown error, exception, or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InvoicingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InvoicingClient.UpdateInvoiceUnit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/invoicing-2024-12-01/UpdateInvoiceUnit" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInvoiceUnitResponse updateInvoiceUnit(Consumer<UpdateInvoiceUnitRequest.Builder> updateInvoiceUnitRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, InvoicingException {
        return updateInvoiceUnit(UpdateInvoiceUnitRequest.builder().applyMutation(updateInvoiceUnitRequest).build());
    }

    /**
     * Create a {@link InvoicingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static InvoicingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link InvoicingClient}.
     */
    static InvoicingClientBuilder builder() {
        return new DefaultInvoicingClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default InvoicingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
