/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvoiceUnitRequest extends InvoicingRequest implements
        ToCopyableBuilder<CreateInvoiceUnitRequest.Builder, CreateInvoiceUnitRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateInvoiceUnitRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INVOICE_RECEIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceReceiver").getter(getter(CreateInvoiceUnitRequest::invoiceReceiver))
            .setter(setter(Builder::invoiceReceiver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceReceiver").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateInvoiceUnitRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> TAX_INHERITANCE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TaxInheritanceDisabled").getter(getter(CreateInvoiceUnitRequest::taxInheritanceDisabled))
            .setter(setter(Builder::taxInheritanceDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxInheritanceDisabled").build())
            .build();

    private static final SdkField<InvoiceUnitRule> RULE_FIELD = SdkField.<InvoiceUnitRule> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(CreateInvoiceUnitRequest::rule)).setter(setter(Builder::rule))
            .constructor(InvoiceUnitRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(CreateInvoiceUnitRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INVOICE_RECEIVER_FIELD, DESCRIPTION_FIELD, TAX_INHERITANCE_DISABLED_FIELD, RULE_FIELD, RESOURCE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String invoiceReceiver;

    private final String description;

    private final Boolean taxInheritanceDisabled;

    private final InvoiceUnitRule rule;

    private final List<ResourceTag> resourceTags;

    private CreateInvoiceUnitRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.invoiceReceiver = builder.invoiceReceiver;
        this.description = builder.description;
        this.taxInheritanceDisabled = builder.taxInheritanceDisabled;
        this.rule = builder.rule;
        this.resourceTags = builder.resourceTags;
    }

    /**
     * <p>
     * The unique name of the invoice unit that is shown on the generated invoice. This can't be changed once it is set.
     * To change this name, you must delete the invoice unit recreate.
     * </p>
     * 
     * @return The unique name of the invoice unit that is shown on the generated invoice. This can't be changed once it
     *         is set. To change this name, you must delete the invoice unit recreate.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices generated for that
     * invoice unit will be sent to this account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices generated
     *         for that invoice unit will be sent to this account ID.
     */
    public final String invoiceReceiver() {
        return invoiceReceiver;
    }

    /**
     * <p>
     * The invoice unit's description. This can be changed at a later time.
     * </p>
     * 
     * @return The invoice unit's description. This can be changed at a later time.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     * </p>
     * 
     * @return Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     */
    public final Boolean taxInheritanceDisabled() {
        return taxInheritanceDisabled;
    }

    /**
     * <p>
     * The <code>InvoiceUnitRule</code> object used to create invoice units.
     * </p>
     * 
     * @return The <code>InvoiceUnitRule</code> object used to create invoice units.
     */
    public final InvoiceUnitRule rule() {
        return rule;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag structure that contains a tag key and value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return The tag structure that contains a tag key and value.
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(invoiceReceiver());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(taxInheritanceDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvoiceUnitRequest)) {
            return false;
        }
        CreateInvoiceUnitRequest other = (CreateInvoiceUnitRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(invoiceReceiver(), other.invoiceReceiver())
                && Objects.equals(description(), other.description())
                && Objects.equals(taxInheritanceDisabled(), other.taxInheritanceDisabled())
                && Objects.equals(rule(), other.rule()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvoiceUnitRequest").add("Name", name()).add("InvoiceReceiver", invoiceReceiver())
                .add("Description", description()).add("TaxInheritanceDisabled", taxInheritanceDisabled()).add("Rule", rule())
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InvoiceReceiver":
            return Optional.ofNullable(clazz.cast(invoiceReceiver()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TaxInheritanceDisabled":
            return Optional.ofNullable(clazz.cast(taxInheritanceDisabled()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("InvoiceReceiver", INVOICE_RECEIVER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TaxInheritanceDisabled", TAX_INHERITANCE_DISABLED_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvoiceUnitRequest, T> g) {
        return obj -> g.apply((CreateInvoiceUnitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInvoiceUnitRequest> {
        /**
         * <p>
         * The unique name of the invoice unit that is shown on the generated invoice. This can't be changed once it is
         * set. To change this name, you must delete the invoice unit recreate.
         * </p>
         * 
         * @param name
         *        The unique name of the invoice unit that is shown on the generated invoice. This can't be changed once
         *        it is set. To change this name, you must delete the invoice unit recreate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices generated for
         * that invoice unit will be sent to this account ID.
         * </p>
         * 
         * @param invoiceReceiver
         *        The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices
         *        generated for that invoice unit will be sent to this account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceReceiver(String invoiceReceiver);

        /**
         * <p>
         * The invoice unit's description. This can be changed at a later time.
         * </p>
         * 
         * @param description
         *        The invoice unit's description. This can be changed at a later time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * </p>
         * 
         * @param taxInheritanceDisabled
         *        Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled);

        /**
         * <p>
         * The <code>InvoiceUnitRule</code> object used to create invoice units.
         * </p>
         * 
         * @param rule
         *        The <code>InvoiceUnitRule</code> object used to create invoice units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(InvoiceUnitRule rule);

        /**
         * <p>
         * The <code>InvoiceUnitRule</code> object used to create invoice units.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceUnitRule.Builder} avoiding the
         * need to create one manually via {@link InvoiceUnitRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceUnitRule.Builder#build()} is called immediately and its
         * result is passed to {@link #rule(InvoiceUnitRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link InvoiceUnitRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(InvoiceUnitRule)
         */
        default Builder rule(Consumer<InvoiceUnitRule.Builder> rule) {
            return rule(InvoiceUnitRule.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The tag structure that contains a tag key and value.
         * </p>
         * 
         * @param resourceTags
         *        The tag structure that contains a tag key and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * The tag structure that contains a tag key and value.
         * </p>
         * 
         * @param resourceTags
         *        The tag structure that contains a tag key and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * The tag structure that contains a tag key and value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.ResourceTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.invoicing.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.ResourceTag.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private String name;

        private String invoiceReceiver;

        private String description;

        private Boolean taxInheritanceDisabled;

        private InvoiceUnitRule rule;

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvoiceUnitRequest model) {
            super(model);
            name(model.name);
            invoiceReceiver(model.invoiceReceiver);
            description(model.description);
            taxInheritanceDisabled(model.taxInheritanceDisabled);
            rule(model.rule);
            resourceTags(model.resourceTags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInvoiceReceiver() {
            return invoiceReceiver;
        }

        public final void setInvoiceReceiver(String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
        }

        @Override
        public final Builder invoiceReceiver(String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getTaxInheritanceDisabled() {
            return taxInheritanceDisabled;
        }

        public final void setTaxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
        }

        @Override
        public final Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        public final InvoiceUnitRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(InvoiceUnitRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(InvoiceUnitRule rule) {
            this.rule = rule;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvoiceUnitRequest build() {
            return new CreateInvoiceUnitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
