/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvoiceUnitResponse extends InvoicingResponse implements
        ToCopyableBuilder<GetInvoiceUnitResponse.Builder, GetInvoiceUnitResponse> {
    private static final SdkField<String> INVOICE_UNIT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceUnitArn").getter(getter(GetInvoiceUnitResponse::invoiceUnitArn))
            .setter(setter(Builder::invoiceUnitArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnitArn").build()).build();

    private static final SdkField<String> INVOICE_RECEIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceReceiver").getter(getter(GetInvoiceUnitResponse::invoiceReceiver))
            .setter(setter(Builder::invoiceReceiver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceReceiver").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetInvoiceUnitResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetInvoiceUnitResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> TAX_INHERITANCE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TaxInheritanceDisabled").getter(getter(GetInvoiceUnitResponse::taxInheritanceDisabled))
            .setter(setter(Builder::taxInheritanceDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxInheritanceDisabled").build())
            .build();

    private static final SdkField<InvoiceUnitRule> RULE_FIELD = SdkField.<InvoiceUnitRule> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(GetInvoiceUnitResponse::rule)).setter(setter(Builder::rule))
            .constructor(InvoiceUnitRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(GetInvoiceUnitResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNIT_ARN_FIELD,
            INVOICE_RECEIVER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAX_INHERITANCE_DISABLED_FIELD, RULE_FIELD,
            LAST_MODIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invoiceUnitArn;

    private final String invoiceReceiver;

    private final String name;

    private final String description;

    private final Boolean taxInheritanceDisabled;

    private final InvoiceUnitRule rule;

    private final Instant lastModified;

    private GetInvoiceUnitResponse(BuilderImpl builder) {
        super(builder);
        this.invoiceUnitArn = builder.invoiceUnitArn;
        this.invoiceReceiver = builder.invoiceReceiver;
        this.name = builder.name;
        this.description = builder.description;
        this.taxInheritanceDisabled = builder.taxInheritanceDisabled;
        this.rule = builder.rule;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * The ARN to identify an invoice unit. This information can't be modified or deleted.
     * </p>
     * 
     * @return The ARN to identify an invoice unit. This information can't be modified or deleted.
     */
    public final String invoiceUnitArn() {
        return invoiceUnitArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices generated for that
     * invoice unit will be sent to this account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices generated
     *         for that invoice unit will be sent to this account ID.
     */
    public final String invoiceReceiver() {
        return invoiceReceiver;
    }

    /**
     * <p>
     * The unique name of the invoice unit that is shown on the generated invoice.
     * </p>
     * 
     * @return The unique name of the invoice unit that is shown on the generated invoice.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The assigned description for an invoice unit.
     * </p>
     * 
     * @return The assigned description for an invoice unit.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     * </p>
     * 
     * @return Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
     */
    public final Boolean taxInheritanceDisabled() {
        return taxInheritanceDisabled;
    }

    /**
     * Returns the value of the Rule property for this object.
     * 
     * @return The value of the Rule property for this object.
     */
    public final InvoiceUnitRule rule() {
        return rule;
    }

    /**
     * <p>
     * The most recent date the invoice unit response was updated.
     * </p>
     * 
     * @return The most recent date the invoice unit response was updated.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invoiceUnitArn());
        hashCode = 31 * hashCode + Objects.hashCode(invoiceReceiver());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(taxInheritanceDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvoiceUnitResponse)) {
            return false;
        }
        GetInvoiceUnitResponse other = (GetInvoiceUnitResponse) obj;
        return Objects.equals(invoiceUnitArn(), other.invoiceUnitArn())
                && Objects.equals(invoiceReceiver(), other.invoiceReceiver()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(taxInheritanceDisabled(), other.taxInheritanceDisabled())
                && Objects.equals(rule(), other.rule()) && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvoiceUnitResponse").add("InvoiceUnitArn", invoiceUnitArn())
                .add("InvoiceReceiver", invoiceReceiver()).add("Name", name()).add("Description", description())
                .add("TaxInheritanceDisabled", taxInheritanceDisabled()).add("Rule", rule()).add("LastModified", lastModified())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceUnitArn":
            return Optional.ofNullable(clazz.cast(invoiceUnitArn()));
        case "InvoiceReceiver":
            return Optional.ofNullable(clazz.cast(invoiceReceiver()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TaxInheritanceDisabled":
            return Optional.ofNullable(clazz.cast(taxInheritanceDisabled()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceUnitArn", INVOICE_UNIT_ARN_FIELD);
        map.put("InvoiceReceiver", INVOICE_RECEIVER_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TaxInheritanceDisabled", TAX_INHERITANCE_DISABLED_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvoiceUnitResponse, T> g) {
        return obj -> g.apply((GetInvoiceUnitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInvoiceUnitResponse> {
        /**
         * <p>
         * The ARN to identify an invoice unit. This information can't be modified or deleted.
         * </p>
         * 
         * @param invoiceUnitArn
         *        The ARN to identify an invoice unit. This information can't be modified or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnitArn(String invoiceUnitArn);

        /**
         * <p>
         * The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices generated for
         * that invoice unit will be sent to this account ID.
         * </p>
         * 
         * @param invoiceReceiver
         *        The Amazon Web Services account ID chosen to be the receiver of an invoice unit. All invoices
         *        generated for that invoice unit will be sent to this account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceReceiver(String invoiceReceiver);

        /**
         * <p>
         * The unique name of the invoice unit that is shown on the generated invoice.
         * </p>
         * 
         * @param name
         *        The unique name of the invoice unit that is shown on the generated invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The assigned description for an invoice unit.
         * </p>
         * 
         * @param description
         *        The assigned description for an invoice unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * </p>
         * 
         * @param taxInheritanceDisabled
         *        Whether the invoice unit based tax inheritance is/ should be enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled);

        /**
         * Sets the value of the Rule property for this object.
         *
         * @param rule
         *        The new value for the Rule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(InvoiceUnitRule rule);

        /**
         * Sets the value of the Rule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InvoiceUnitRule.Builder} avoiding the
         * need to create one manually via {@link InvoiceUnitRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceUnitRule.Builder#build()} is called immediately and its
         * result is passed to {@link #rule(InvoiceUnitRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link InvoiceUnitRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(InvoiceUnitRule)
         */
        default Builder rule(Consumer<InvoiceUnitRule.Builder> rule) {
            return rule(InvoiceUnitRule.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The most recent date the invoice unit response was updated.
         * </p>
         * 
         * @param lastModified
         *        The most recent date the invoice unit response was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);
    }

    static final class BuilderImpl extends InvoicingResponse.BuilderImpl implements Builder {
        private String invoiceUnitArn;

        private String invoiceReceiver;

        private String name;

        private String description;

        private Boolean taxInheritanceDisabled;

        private InvoiceUnitRule rule;

        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvoiceUnitResponse model) {
            super(model);
            invoiceUnitArn(model.invoiceUnitArn);
            invoiceReceiver(model.invoiceReceiver);
            name(model.name);
            description(model.description);
            taxInheritanceDisabled(model.taxInheritanceDisabled);
            rule(model.rule);
            lastModified(model.lastModified);
        }

        public final String getInvoiceUnitArn() {
            return invoiceUnitArn;
        }

        public final void setInvoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
        }

        @Override
        public final Builder invoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
            return this;
        }

        public final String getInvoiceReceiver() {
            return invoiceReceiver;
        }

        public final void setInvoiceReceiver(String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
        }

        @Override
        public final Builder invoiceReceiver(String invoiceReceiver) {
            this.invoiceReceiver = invoiceReceiver;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getTaxInheritanceDisabled() {
            return taxInheritanceDisabled;
        }

        public final void setTaxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
        }

        @Override
        public final Builder taxInheritanceDisabled(Boolean taxInheritanceDisabled) {
            this.taxInheritanceDisabled = taxInheritanceDisabled;
            return this;
        }

        public final InvoiceUnitRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(InvoiceUnitRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(InvoiceUnitRule rule) {
            this.rule = rule;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public GetInvoiceUnitResponse build() {
            return new GetInvoiceUnitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
