/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The billing period for which you want to retrieve invoice-related documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingPeriod implements SdkPojo, Serializable, ToCopyableBuilder<BillingPeriod.Builder, BillingPeriod> {
    private static final SdkField<Integer> MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Month")
            .getter(getter(BillingPeriod::month)).setter(setter(Builder::month))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Month").build()).build();

    private static final SdkField<Integer> YEAR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Year")
            .getter(getter(BillingPeriod::year)).setter(setter(Builder::year))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Year").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTH_FIELD, YEAR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer month;

    private final Integer year;

    private BillingPeriod(BuilderImpl builder) {
        this.month = builder.month;
        this.year = builder.year;
    }

    /**
     * <p>
     * The billing period month.
     * </p>
     * 
     * @return The billing period month.
     */
    public final Integer month() {
        return month;
    }

    /**
     * <p>
     * The billing period year.
     * </p>
     * 
     * @return The billing period year.
     */
    public final Integer year() {
        return year;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(month());
        hashCode = 31 * hashCode + Objects.hashCode(year());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingPeriod)) {
            return false;
        }
        BillingPeriod other = (BillingPeriod) obj;
        return Objects.equals(month(), other.month()) && Objects.equals(year(), other.year());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingPeriod").add("Month", month()).add("Year", year()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Month":
            return Optional.ofNullable(clazz.cast(month()));
        case "Year":
            return Optional.ofNullable(clazz.cast(year()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Month", MONTH_FIELD);
        map.put("Year", YEAR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingPeriod, T> g) {
        return obj -> g.apply((BillingPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingPeriod> {
        /**
         * <p>
         * The billing period month.
         * </p>
         * 
         * @param month
         *        The billing period month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder month(Integer month);

        /**
         * <p>
         * The billing period year.
         * </p>
         * 
         * @param year
         *        The billing period year.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder year(Integer year);
    }

    static final class BuilderImpl implements Builder {
        private Integer month;

        private Integer year;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingPeriod model) {
            month(model.month);
            year(model.year);
        }

        public final Integer getMonth() {
            return month;
        }

        public final void setMonth(Integer month) {
            this.month = month;
        }

        @Override
        public final Builder month(Integer month) {
            this.month = month;
            return this;
        }

        public final Integer getYear() {
            return year;
        }

        public final void setYear(Integer year) {
            this.year = year;
        }

        @Override
        public final Builder year(Integer year) {
            this.year = year;
            return this;
        }

        @Override
        public BillingPeriod build() {
            return new BillingPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
