/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvoicePdfResponse extends InvoicingResponse implements
        ToCopyableBuilder<GetInvoicePdfResponse.Builder, GetInvoicePdfResponse> {
    private static final SdkField<InvoicePDF> INVOICE_PDF_FIELD = SdkField.<InvoicePDF> builder(MarshallingType.SDK_POJO)
            .memberName("InvoicePDF").getter(getter(GetInvoicePdfResponse::invoicePDF)).setter(setter(Builder::invoicePDF))
            .constructor(InvoicePDF::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoicePDF").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_PDF_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InvoicePDF invoicePDF;

    private GetInvoicePdfResponse(BuilderImpl builder) {
        super(builder);
        this.invoicePDF = builder.invoicePDF;
    }

    /**
     * <p>
     * The invoice document and supplemental documents associated with the invoice.
     * </p>
     * 
     * @return The invoice document and supplemental documents associated with the invoice.
     */
    public final InvoicePDF invoicePDF() {
        return invoicePDF;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invoicePDF());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvoicePdfResponse)) {
            return false;
        }
        GetInvoicePdfResponse other = (GetInvoicePdfResponse) obj;
        return Objects.equals(invoicePDF(), other.invoicePDF());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvoicePdfResponse").add("InvoicePDF", invoicePDF()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoicePDF":
            return Optional.ofNullable(clazz.cast(invoicePDF()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoicePDF", INVOICE_PDF_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvoicePdfResponse, T> g) {
        return obj -> g.apply((GetInvoicePdfResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInvoicePdfResponse> {
        /**
         * <p>
         * The invoice document and supplemental documents associated with the invoice.
         * </p>
         * 
         * @param invoicePDF
         *        The invoice document and supplemental documents associated with the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoicePDF(InvoicePDF invoicePDF);

        /**
         * <p>
         * The invoice document and supplemental documents associated with the invoice.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoicePDF.Builder} avoiding the need to
         * create one manually via {@link InvoicePDF#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoicePDF.Builder#build()} is called immediately and its result
         * is passed to {@link #invoicePDF(InvoicePDF)}.
         * 
         * @param invoicePDF
         *        a consumer that will call methods on {@link InvoicePDF.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invoicePDF(InvoicePDF)
         */
        default Builder invoicePDF(Consumer<InvoicePDF.Builder> invoicePDF) {
            return invoicePDF(InvoicePDF.builder().applyMutation(invoicePDF).build());
        }
    }

    static final class BuilderImpl extends InvoicingResponse.BuilderImpl implements Builder {
        private InvoicePDF invoicePDF;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvoicePdfResponse model) {
            super(model);
            invoicePDF(model.invoicePDF);
        }

        public final InvoicePDF.Builder getInvoicePDF() {
            return invoicePDF != null ? invoicePDF.toBuilder() : null;
        }

        public final void setInvoicePDF(InvoicePDF.BuilderImpl invoicePDF) {
            this.invoicePDF = invoicePDF != null ? invoicePDF.build() : null;
        }

        @Override
        public final Builder invoicePDF(InvoicePDF invoicePDF) {
            this.invoicePDF = invoicePDF;
            return this;
        }

        @Override
        public GetInvoicePdfResponse build() {
            return new GetInvoicePdfResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
