/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount charged after taxes, in the preferred currency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoiceCurrencyAmount implements SdkPojo, Serializable,
        ToCopyableBuilder<InvoiceCurrencyAmount.Builder, InvoiceCurrencyAmount> {
    private static final SdkField<String> TOTAL_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalAmount").getter(getter(InvoiceCurrencyAmount::totalAmount)).setter(setter(Builder::totalAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmount").build()).build();

    private static final SdkField<String> TOTAL_AMOUNT_BEFORE_TAX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalAmountBeforeTax").getter(getter(InvoiceCurrencyAmount::totalAmountBeforeTax))
            .setter(setter(Builder::totalAmountBeforeTax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmountBeforeTax").build())
            .build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(InvoiceCurrencyAmount::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<AmountBreakdown> AMOUNT_BREAKDOWN_FIELD = SdkField
            .<AmountBreakdown> builder(MarshallingType.SDK_POJO).memberName("AmountBreakdown")
            .getter(getter(InvoiceCurrencyAmount::amountBreakdown)).setter(setter(Builder::amountBreakdown))
            .constructor(AmountBreakdown::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmountBreakdown").build()).build();

    private static final SdkField<CurrencyExchangeDetails> CURRENCY_EXCHANGE_DETAILS_FIELD = SdkField
            .<CurrencyExchangeDetails> builder(MarshallingType.SDK_POJO).memberName("CurrencyExchangeDetails")
            .getter(getter(InvoiceCurrencyAmount::currencyExchangeDetails)).setter(setter(Builder::currencyExchangeDetails))
            .constructor(CurrencyExchangeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyExchangeDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_AMOUNT_FIELD,
            TOTAL_AMOUNT_BEFORE_TAX_FIELD, CURRENCY_CODE_FIELD, AMOUNT_BREAKDOWN_FIELD, CURRENCY_EXCHANGE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String totalAmount;

    private final String totalAmountBeforeTax;

    private final String currencyCode;

    private final AmountBreakdown amountBreakdown;

    private final CurrencyExchangeDetails currencyExchangeDetails;

    private InvoiceCurrencyAmount(BuilderImpl builder) {
        this.totalAmount = builder.totalAmount;
        this.totalAmountBeforeTax = builder.totalAmountBeforeTax;
        this.currencyCode = builder.currencyCode;
        this.amountBreakdown = builder.amountBreakdown;
        this.currencyExchangeDetails = builder.currencyExchangeDetails;
    }

    /**
     * <p>
     * The invoice currency amount.
     * </p>
     * 
     * @return The invoice currency amount.
     */
    public final String totalAmount() {
        return totalAmount;
    }

    /**
     * <p>
     * Details about the invoice total amount before tax.
     * </p>
     * 
     * @return Details about the invoice total amount before tax.
     */
    public final String totalAmountBeforeTax() {
        return totalAmountBeforeTax;
    }

    /**
     * <p>
     * The currency dominion of the invoice document.
     * </p>
     * 
     * @return The currency dominion of the invoice document.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * Details about the invoice currency amount.
     * </p>
     * 
     * @return Details about the invoice currency amount.
     */
    public final AmountBreakdown amountBreakdown() {
        return amountBreakdown;
    }

    /**
     * <p>
     * The details of currency exchange.
     * </p>
     * 
     * @return The details of currency exchange.
     */
    public final CurrencyExchangeDetails currencyExchangeDetails() {
        return currencyExchangeDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalAmount());
        hashCode = 31 * hashCode + Objects.hashCode(totalAmountBeforeTax());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(amountBreakdown());
        hashCode = 31 * hashCode + Objects.hashCode(currencyExchangeDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceCurrencyAmount)) {
            return false;
        }
        InvoiceCurrencyAmount other = (InvoiceCurrencyAmount) obj;
        return Objects.equals(totalAmount(), other.totalAmount())
                && Objects.equals(totalAmountBeforeTax(), other.totalAmountBeforeTax())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(amountBreakdown(), other.amountBreakdown())
                && Objects.equals(currencyExchangeDetails(), other.currencyExchangeDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoiceCurrencyAmount").add("TotalAmount", totalAmount())
                .add("TotalAmountBeforeTax", totalAmountBeforeTax()).add("CurrencyCode", currencyCode())
                .add("AmountBreakdown", amountBreakdown()).add("CurrencyExchangeDetails", currencyExchangeDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalAmount":
            return Optional.ofNullable(clazz.cast(totalAmount()));
        case "TotalAmountBeforeTax":
            return Optional.ofNullable(clazz.cast(totalAmountBeforeTax()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "AmountBreakdown":
            return Optional.ofNullable(clazz.cast(amountBreakdown()));
        case "CurrencyExchangeDetails":
            return Optional.ofNullable(clazz.cast(currencyExchangeDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalAmount", TOTAL_AMOUNT_FIELD);
        map.put("TotalAmountBeforeTax", TOTAL_AMOUNT_BEFORE_TAX_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("AmountBreakdown", AMOUNT_BREAKDOWN_FIELD);
        map.put("CurrencyExchangeDetails", CURRENCY_EXCHANGE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceCurrencyAmount, T> g) {
        return obj -> g.apply((InvoiceCurrencyAmount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoiceCurrencyAmount> {
        /**
         * <p>
         * The invoice currency amount.
         * </p>
         * 
         * @param totalAmount
         *        The invoice currency amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAmount(String totalAmount);

        /**
         * <p>
         * Details about the invoice total amount before tax.
         * </p>
         * 
         * @param totalAmountBeforeTax
         *        Details about the invoice total amount before tax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAmountBeforeTax(String totalAmountBeforeTax);

        /**
         * <p>
         * The currency dominion of the invoice document.
         * </p>
         * 
         * @param currencyCode
         *        The currency dominion of the invoice document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Details about the invoice currency amount.
         * </p>
         * 
         * @param amountBreakdown
         *        Details about the invoice currency amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amountBreakdown(AmountBreakdown amountBreakdown);

        /**
         * <p>
         * Details about the invoice currency amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmountBreakdown.Builder} avoiding the
         * need to create one manually via {@link AmountBreakdown#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmountBreakdown.Builder#build()} is called immediately and its
         * result is passed to {@link #amountBreakdown(AmountBreakdown)}.
         * 
         * @param amountBreakdown
         *        a consumer that will call methods on {@link AmountBreakdown.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amountBreakdown(AmountBreakdown)
         */
        default Builder amountBreakdown(Consumer<AmountBreakdown.Builder> amountBreakdown) {
            return amountBreakdown(AmountBreakdown.builder().applyMutation(amountBreakdown).build());
        }

        /**
         * <p>
         * The details of currency exchange.
         * </p>
         * 
         * @param currencyExchangeDetails
         *        The details of currency exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyExchangeDetails(CurrencyExchangeDetails currencyExchangeDetails);

        /**
         * <p>
         * The details of currency exchange.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrencyExchangeDetails.Builder} avoiding
         * the need to create one manually via {@link CurrencyExchangeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrencyExchangeDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #currencyExchangeDetails(CurrencyExchangeDetails)}.
         * 
         * @param currencyExchangeDetails
         *        a consumer that will call methods on {@link CurrencyExchangeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currencyExchangeDetails(CurrencyExchangeDetails)
         */
        default Builder currencyExchangeDetails(Consumer<CurrencyExchangeDetails.Builder> currencyExchangeDetails) {
            return currencyExchangeDetails(CurrencyExchangeDetails.builder().applyMutation(currencyExchangeDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String totalAmount;

        private String totalAmountBeforeTax;

        private String currencyCode;

        private AmountBreakdown amountBreakdown;

        private CurrencyExchangeDetails currencyExchangeDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceCurrencyAmount model) {
            totalAmount(model.totalAmount);
            totalAmountBeforeTax(model.totalAmountBeforeTax);
            currencyCode(model.currencyCode);
            amountBreakdown(model.amountBreakdown);
            currencyExchangeDetails(model.currencyExchangeDetails);
        }

        public final String getTotalAmount() {
            return totalAmount;
        }

        public final void setTotalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Override
        public final Builder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public final String getTotalAmountBeforeTax() {
            return totalAmountBeforeTax;
        }

        public final void setTotalAmountBeforeTax(String totalAmountBeforeTax) {
            this.totalAmountBeforeTax = totalAmountBeforeTax;
        }

        @Override
        public final Builder totalAmountBeforeTax(String totalAmountBeforeTax) {
            this.totalAmountBeforeTax = totalAmountBeforeTax;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final AmountBreakdown.Builder getAmountBreakdown() {
            return amountBreakdown != null ? amountBreakdown.toBuilder() : null;
        }

        public final void setAmountBreakdown(AmountBreakdown.BuilderImpl amountBreakdown) {
            this.amountBreakdown = amountBreakdown != null ? amountBreakdown.build() : null;
        }

        @Override
        public final Builder amountBreakdown(AmountBreakdown amountBreakdown) {
            this.amountBreakdown = amountBreakdown;
            return this;
        }

        public final CurrencyExchangeDetails.Builder getCurrencyExchangeDetails() {
            return currencyExchangeDetails != null ? currencyExchangeDetails.toBuilder() : null;
        }

        public final void setCurrencyExchangeDetails(CurrencyExchangeDetails.BuilderImpl currencyExchangeDetails) {
            this.currencyExchangeDetails = currencyExchangeDetails != null ? currencyExchangeDetails.build() : null;
        }

        @Override
        public final Builder currencyExchangeDetails(CurrencyExchangeDetails currencyExchangeDetails) {
            this.currencyExchangeDetails = currencyExchangeDetails;
            return this;
        }

        @Override
        public InvoiceCurrencyAmount build() {
            return new InvoiceCurrencyAmount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
