/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Invoice document data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoicePDF implements SdkPojo, Serializable, ToCopyableBuilder<InvoicePDF.Builder, InvoicePDF> {
    private static final SdkField<String> INVOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceId").getter(getter(InvoicePDF::invoiceId)).setter(setter(Builder::invoiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceId").build()).build();

    private static final SdkField<String> DOCUMENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentUrl").getter(getter(InvoicePDF::documentUrl)).setter(setter(Builder::documentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrl").build()).build();

    private static final SdkField<Instant> DOCUMENT_URL_EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("DocumentUrlExpirationDate")
            .getter(getter(InvoicePDF::documentUrlExpirationDate)).setter(setter(Builder::documentUrlExpirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrlExpirationDate").build())
            .build();

    private static final SdkField<List<SupplementalDocument>> SUPPLEMENTAL_DOCUMENTS_FIELD = SdkField
            .<List<SupplementalDocument>> builder(MarshallingType.LIST)
            .memberName("SupplementalDocuments")
            .getter(getter(InvoicePDF::supplementalDocuments))
            .setter(setter(Builder::supplementalDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupplementalDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupplementalDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_ID_FIELD,
            DOCUMENT_URL_FIELD, DOCUMENT_URL_EXPIRATION_DATE_FIELD, SUPPLEMENTAL_DOCUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String invoiceId;

    private final String documentUrl;

    private final Instant documentUrlExpirationDate;

    private final List<SupplementalDocument> supplementalDocuments;

    private InvoicePDF(BuilderImpl builder) {
        this.invoiceId = builder.invoiceId;
        this.documentUrl = builder.documentUrl;
        this.documentUrlExpirationDate = builder.documentUrlExpirationDate;
        this.supplementalDocuments = builder.supplementalDocuments;
    }

    /**
     * <p>
     * Your unique invoice ID.
     * </p>
     * 
     * @return Your unique invoice ID.
     */
    public final String invoiceId() {
        return invoiceId;
    }

    /**
     * <p>
     * The pre-signed URL to download the invoice document.
     * </p>
     * 
     * @return The pre-signed URL to download the invoice document.
     */
    public final String documentUrl() {
        return documentUrl;
    }

    /**
     * <p>
     * The pre-signed URL expiration date of the invoice document.
     * </p>
     * 
     * @return The pre-signed URL expiration date of the invoice document.
     */
    public final Instant documentUrlExpirationDate() {
        return documentUrlExpirationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupplementalDocuments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupplementalDocuments() {
        return supplementalDocuments != null && !(supplementalDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of supplemental documents associated with the invoice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupplementalDocuments} method.
     * </p>
     * 
     * @return List of supplemental documents associated with the invoice.
     */
    public final List<SupplementalDocument> supplementalDocuments() {
        return supplementalDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(documentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(documentUrlExpirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupplementalDocuments() ? supplementalDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoicePDF)) {
            return false;
        }
        InvoicePDF other = (InvoicePDF) obj;
        return Objects.equals(invoiceId(), other.invoiceId()) && Objects.equals(documentUrl(), other.documentUrl())
                && Objects.equals(documentUrlExpirationDate(), other.documentUrlExpirationDate())
                && hasSupplementalDocuments() == other.hasSupplementalDocuments()
                && Objects.equals(supplementalDocuments(), other.supplementalDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoicePDF").add("InvoiceId", invoiceId()).add("DocumentUrl", documentUrl())
                .add("DocumentUrlExpirationDate", documentUrlExpirationDate())
                .add("SupplementalDocuments", hasSupplementalDocuments() ? supplementalDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceId":
            return Optional.ofNullable(clazz.cast(invoiceId()));
        case "DocumentUrl":
            return Optional.ofNullable(clazz.cast(documentUrl()));
        case "DocumentUrlExpirationDate":
            return Optional.ofNullable(clazz.cast(documentUrlExpirationDate()));
        case "SupplementalDocuments":
            return Optional.ofNullable(clazz.cast(supplementalDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceId", INVOICE_ID_FIELD);
        map.put("DocumentUrl", DOCUMENT_URL_FIELD);
        map.put("DocumentUrlExpirationDate", DOCUMENT_URL_EXPIRATION_DATE_FIELD);
        map.put("SupplementalDocuments", SUPPLEMENTAL_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoicePDF, T> g) {
        return obj -> g.apply((InvoicePDF) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoicePDF> {
        /**
         * <p>
         * Your unique invoice ID.
         * </p>
         * 
         * @param invoiceId
         *        Your unique invoice ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceId(String invoiceId);

        /**
         * <p>
         * The pre-signed URL to download the invoice document.
         * </p>
         * 
         * @param documentUrl
         *        The pre-signed URL to download the invoice document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentUrl(String documentUrl);

        /**
         * <p>
         * The pre-signed URL expiration date of the invoice document.
         * </p>
         * 
         * @param documentUrlExpirationDate
         *        The pre-signed URL expiration date of the invoice document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentUrlExpirationDate(Instant documentUrlExpirationDate);

        /**
         * <p>
         * List of supplemental documents associated with the invoice.
         * </p>
         * 
         * @param supplementalDocuments
         *        List of supplemental documents associated with the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalDocuments(Collection<SupplementalDocument> supplementalDocuments);

        /**
         * <p>
         * List of supplemental documents associated with the invoice.
         * </p>
         * 
         * @param supplementalDocuments
         *        List of supplemental documents associated with the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalDocuments(SupplementalDocument... supplementalDocuments);

        /**
         * <p>
         * List of supplemental documents associated with the invoice.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.SupplementalDocument.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.invoicing.model.SupplementalDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.SupplementalDocument.Builder#build()} is called
         * immediately and its result is passed to {@link #supplementalDocuments(List<SupplementalDocument>)}.
         * 
         * @param supplementalDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.SupplementalDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supplementalDocuments(java.util.Collection<SupplementalDocument>)
         */
        Builder supplementalDocuments(Consumer<SupplementalDocument.Builder>... supplementalDocuments);
    }

    static final class BuilderImpl implements Builder {
        private String invoiceId;

        private String documentUrl;

        private Instant documentUrlExpirationDate;

        private List<SupplementalDocument> supplementalDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvoicePDF model) {
            invoiceId(model.invoiceId);
            documentUrl(model.documentUrl);
            documentUrlExpirationDate(model.documentUrlExpirationDate);
            supplementalDocuments(model.supplementalDocuments);
        }

        public final String getInvoiceId() {
            return invoiceId;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final String getDocumentUrl() {
            return documentUrl;
        }

        public final void setDocumentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
        }

        @Override
        public final Builder documentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }

        public final Instant getDocumentUrlExpirationDate() {
            return documentUrlExpirationDate;
        }

        public final void setDocumentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
        }

        @Override
        public final Builder documentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
            return this;
        }

        public final List<SupplementalDocument.Builder> getSupplementalDocuments() {
            List<SupplementalDocument.Builder> result = SupplementalDocumentsCopier.copyToBuilder(this.supplementalDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupplementalDocuments(Collection<SupplementalDocument.BuilderImpl> supplementalDocuments) {
            this.supplementalDocuments = SupplementalDocumentsCopier.copyFromBuilder(supplementalDocuments);
        }

        @Override
        public final Builder supplementalDocuments(Collection<SupplementalDocument> supplementalDocuments) {
            this.supplementalDocuments = SupplementalDocumentsCopier.copy(supplementalDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalDocuments(SupplementalDocument... supplementalDocuments) {
            supplementalDocuments(Arrays.asList(supplementalDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalDocuments(Consumer<SupplementalDocument.Builder>... supplementalDocuments) {
            supplementalDocuments(Stream.of(supplementalDocuments)
                    .map(c -> SupplementalDocument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InvoicePDF build() {
            return new InvoicePDF(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
