/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.CACertificateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CA certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CACertificate implements StructuredPojo, ToCopyableBuilder<CACertificate.Builder, CACertificate> {
    private final String certificateArn;

    private final String certificateId;

    private final String status;

    private final Date creationDate;

    private CACertificate(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ARN of the CA certificate.
     * </p>
     * 
     * @return The ARN of the CA certificate.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the CA certificate.
     * </p>
     * 
     * @return The ID of the CA certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The status of the CA certificate.
     * </p>
     * <p>
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * 
     * @return The status of the CA certificate.</p>
     *         <p>
     *         The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CACertificateStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date the CA certificate was created.
     * </p>
     * 
     * @return The date the CA certificate was created.
     */
    public Date creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateArn() == null) ? 0 : certificateArn().hashCode());
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((creationDate() == null) ? 0 : creationDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificate)) {
            return false;
        }
        CACertificate other = (CACertificate) obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificateArn() != null) {
            sb.append("CertificateArn: ").append(certificateArn()).append(",");
        }
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CACertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CACertificate> {
        /**
         * <p>
         * The ARN of the CA certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the CA certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The status of the CA certificate.
         * </p>
         * <p>
         * The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param status
         *        The status of the CA certificate.</p>
         *        <p>
         *        The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the CA certificate.
         * </p>
         * <p>
         * The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param status
         *        The status of the CA certificate.</p>
         *        <p>
         *        The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(CACertificateStatus status);

        /**
         * <p>
         * The date the CA certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date the CA certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Date creationDate);
    }

    private static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String status;

        private Date creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificate model) {
            setCertificateArn(model.certificateArn);
            setCertificateId(model.certificateId);
            setStatus(model.status);
            setCreationDate(model.creationDate);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(CACertificateStatus status) {
            this.status(status.toString());
        }

        public final Date getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
            return this;
        }

        public final void setCreationDate(Date creationDate) {
            this.creationDate = StandardMemberCopier.copy(creationDate);
        }

        @Override
        public CACertificate build() {
            return new CACertificate(this);
        }
    }
}
