/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import static software.amazon.awssdk.util.StringUtils.isNullOrEmpty;

import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum CertificateStatus {
    ACTIVE("ACTIVE"),

    INACTIVE("INACTIVE"),

    REVOKED("REVOKED"),

    PENDING_TRANSFER("PENDING_TRANSFER"),

    REGISTER_INACTIVE("REGISTER_INACTIVE"),

    PENDING_ACTIVATION("PENDING_ACTIVATION");

    private final String value;

    private CertificateStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return CertificateStatus corresponding to the value
     */
    public static CertificateStatus fromValue(String value) {
        if (isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(CertificateStatus.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}
