/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the DescribeThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeThingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeThingResponse.Builder, DescribeThingResponse> {
    private final String defaultClientId;

    private final String thingName;

    private final String thingTypeName;

    private final Map<String, String> attributes;

    private final Long version;

    private DescribeThingResponse(BuilderImpl builder) {
        this.defaultClientId = builder.defaultClientId;
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributes = builder.attributes;
        this.version = builder.version;
    }

    /**
     * <p>
     * The default client ID.
     * </p>
     * 
     * @return The default client ID.
     */
    public String defaultClientId() {
        return defaultClientId;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The thing type name.
     * </p>
     * 
     * @return The thing type name.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The thing attributes.
     * </p>
     * 
     * @return The thing attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The current version of the thing record in the registry.
     * </p>
     * <note>
     * <p>
     * To avoid unintentional changes to the information in the registry, you can pass the version information in the
     * <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.
     * </p>
     * </note>
     * 
     * @return The current version of the thing record in the registry.</p> <note>
     *         <p>
     *         To avoid unintentional changes to the information in the registry, you can pass the version information
     *         in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and
     *         <code>DeleteThing</code> calls.
     *         </p>
     */
    public Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((defaultClientId() == null) ? 0 : defaultClientId().hashCode());
        hashCode = 31 * hashCode + ((thingName() == null) ? 0 : thingName().hashCode());
        hashCode = 31 * hashCode + ((thingTypeName() == null) ? 0 : thingTypeName().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingResponse)) {
            return false;
        }
        DescribeThingResponse other = (DescribeThingResponse) obj;
        if (other.defaultClientId() == null ^ this.defaultClientId() == null) {
            return false;
        }
        if (other.defaultClientId() != null && !other.defaultClientId().equals(this.defaultClientId())) {
            return false;
        }
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (defaultClientId() != null) {
            sb.append("DefaultClientId: ").append(defaultClientId()).append(",");
        }
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeThingResponse> {
        /**
         * <p>
         * The default client ID.
         * </p>
         * 
         * @param defaultClientId
         *        The default client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultClientId(String defaultClientId);

        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The thing type name.
         * </p>
         * 
         * @param thingTypeName
         *        The thing type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The thing attributes.
         * </p>
         * 
         * @param attributes
         *        The thing attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The current version of the thing record in the registry.
         * </p>
         * <note>
         * <p>
         * To avoid unintentional changes to the information in the registry, you can pass the version information in
         * the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code>
         * calls.
         * </p>
         * </note>
         * 
         * @param version
         *        The current version of the thing record in the registry.</p> <note>
         *        <p>
         *        To avoid unintentional changes to the information in the registry, you can pass the version
         *        information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and
         *        <code>DeleteThing</code> calls.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    private static final class BuilderImpl implements Builder {
        private String defaultClientId;

        private String thingName;

        private String thingTypeName;

        private Map<String, String> attributes;

        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingResponse model) {
            setDefaultClientId(model.defaultClientId);
            setThingName(model.thingName);
            setThingTypeName(model.thingTypeName);
            setAttributes(model.attributes);
            setVersion(model.version);
        }

        public final String getDefaultClientId() {
            return defaultClientId;
        }

        @Override
        public final Builder defaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        public final void setDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public DescribeThingResponse build() {
            return new DescribeThingResponse(this);
        }
    }
}
