/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListCACertificates operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCACertificatesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListCACertificatesResponse.Builder, ListCACertificatesResponse> {
    private final List<CACertificate> certificates;

    private final String nextMarker;

    private ListCACertificatesResponse(BuilderImpl builder) {
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The CA certificates registered in your AWS account.
     * </p>
     * 
     * @return The CA certificates registered in your AWS account.
     */
    public List<CACertificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * The current position within the list of CA certificates.
     * </p>
     * 
     * @return The current position within the list of CA certificates.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificates() == null) ? 0 : certificates().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCACertificatesResponse)) {
            return false;
        }
        ListCACertificatesResponse other = (ListCACertificatesResponse) obj;
        if (other.certificates() == null ^ this.certificates() == null) {
            return false;
        }
        if (other.certificates() != null && !other.certificates().equals(this.certificates())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (certificates() != null) {
            sb.append("Certificates: ").append(certificates()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListCACertificatesResponse> {
        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * 
         * @param certificates
         *        The CA certificates registered in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<CACertificate> certificates);

        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCertificates(java.util.Collection)} or {@link #withCertificates(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param certificates
         *        The CA certificates registered in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(CACertificate... certificates);

        /**
         * <p>
         * The current position within the list of CA certificates.
         * </p>
         * 
         * @param nextMarker
         *        The current position within the list of CA certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    private static final class BuilderImpl implements Builder {
        private List<CACertificate> certificates;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCACertificatesResponse model) {
            setCertificates(model.certificates);
            setNextMarker(model.nextMarker);
        }

        public final Collection<CACertificate> getCertificates() {
            return certificates;
        }

        @Override
        public final Builder certificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(CACertificate... certificates) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<>(certificates.length);
            }
            for (CACertificate e : certificates) {
                this.certificates.add(e);
            }
            return this;
        }

        public final void setCertificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
        }

        @SafeVarargs
        public final void setCertificates(CACertificate... certificates) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<>(certificates.length);
            }
            for (CACertificate e : certificates) {
                this.certificates.add(e);
            }
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCACertificatesResponse build() {
            return new ListCACertificatesResponse(this);
        }
    }
}
