/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListOutgoingCertificates operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOutgoingCertificatesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOutgoingCertificatesResponse.Builder, ListOutgoingCertificatesResponse> {
    private final List<OutgoingCertificate> outgoingCertificates;

    private final String nextMarker;

    private ListOutgoingCertificatesResponse(BuilderImpl builder) {
        this.outgoingCertificates = builder.outgoingCertificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The certificates that are being transfered but not yet accepted.
     * </p>
     * 
     * @return The certificates that are being transfered but not yet accepted.
     */
    public List<OutgoingCertificate> outgoingCertificates() {
        return outgoingCertificates;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((outgoingCertificates() == null) ? 0 : outgoingCertificates().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingCertificatesResponse)) {
            return false;
        }
        ListOutgoingCertificatesResponse other = (ListOutgoingCertificatesResponse) obj;
        if (other.outgoingCertificates() == null ^ this.outgoingCertificates() == null) {
            return false;
        }
        if (other.outgoingCertificates() != null && !other.outgoingCertificates().equals(this.outgoingCertificates())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (outgoingCertificates() != null) {
            sb.append("OutgoingCertificates: ").append(outgoingCertificates()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
        /**
         * <p>
         * The certificates that are being transfered but not yet accepted.
         * </p>
         * 
         * @param outgoingCertificates
         *        The certificates that are being transfered but not yet accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates);

        /**
         * <p>
         * The certificates that are being transfered but not yet accepted.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOutgoingCertificates(java.util.Collection)} or
         * {@link #withOutgoingCertificates(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param outgoingCertificates
         *        The certificates that are being transfered but not yet accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingCertificates(OutgoingCertificate... outgoingCertificates);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    private static final class BuilderImpl implements Builder {
        private List<OutgoingCertificate> outgoingCertificates;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingCertificatesResponse model) {
            setOutgoingCertificates(model.outgoingCertificates);
            setNextMarker(model.nextMarker);
        }

        public final Collection<OutgoingCertificate> getOutgoingCertificates() {
            return outgoingCertificates;
        }

        @Override
        public final Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(OutgoingCertificate... outgoingCertificates) {
            if (this.outgoingCertificates == null) {
                this.outgoingCertificates = new ArrayList<>(outgoingCertificates.length);
            }
            for (OutgoingCertificate e : outgoingCertificates) {
                this.outgoingCertificates.add(e);
            }
            return this;
        }

        public final void setOutgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
        }

        @SafeVarargs
        public final void setOutgoingCertificates(OutgoingCertificate... outgoingCertificates) {
            if (this.outgoingCertificates == null) {
                this.outgoingCertificates = new ArrayList<>(outgoingCertificates.length);
            }
            for (OutgoingCertificate e : outgoingCertificates) {
                this.outgoingCertificates.add(e);
            }
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListOutgoingCertificatesResponse build() {
            return new ListOutgoingCertificatesResponse(this);
        }
    }
}
