/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListThingPrincipals operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListThingPrincipalsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListThingPrincipalsResponse.Builder, ListThingPrincipalsResponse> {
    private final List<String> principals;

    private ListThingPrincipalsResponse(BuilderImpl builder) {
        this.principals = builder.principals;
    }

    /**
     * <p>
     * The principals associated with the thing.
     * </p>
     * 
     * @return The principals associated with the thing.
     */
    public List<String> principals() {
        return principals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((principals() == null) ? 0 : principals().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsResponse)) {
            return false;
        }
        ListThingPrincipalsResponse other = (ListThingPrincipalsResponse) obj;
        if (other.principals() == null ^ this.principals() == null) {
            return false;
        }
        if (other.principals() != null && !other.principals().equals(this.principals())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (principals() != null) {
            sb.append("Principals: ").append(principals()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListThingPrincipalsResponse> {
        /**
         * <p>
         * The principals associated with the thing.
         * </p>
         * 
         * @param principals
         *        The principals associated with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The principals associated with the thing.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setPrincipals(java.util.Collection)} or {@link #withPrincipals(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param principals
         *        The principals associated with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> principals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsResponse model) {
            setPrincipals(model.principals);
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            if (this.principals == null) {
                this.principals = new ArrayList<>(principals.length);
            }
            for (String e : principals) {
                this.principals.add(e);
            }
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        @SafeVarargs
        public final void setPrincipals(String... principals) {
            if (this.principals == null) {
                this.principals = new ArrayList<>(principals.length);
            }
            for (String e : principals) {
                this.principals.add(e);
            }
        }

        @Override
        public ListThingPrincipalsResponse build() {
            return new ListThingPrincipalsResponse(this);
        }
    }
}
