/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListThings operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListThingsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListThingsResponse.Builder, ListThingsResponse> {
    private final List<ThingAttribute> things;

    private final String nextToken;

    private ListThingsResponse(BuilderImpl builder) {
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The things.
     * </p>
     * 
     * @return The things.
     */
    public List<ThingAttribute> things() {
        return things;
    }

    /**
     * <p>
     * The token for the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((things() == null) ? 0 : things().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsResponse)) {
            return false;
        }
        ListThingsResponse other = (ListThingsResponse) obj;
        if (other.things() == null ^ this.things() == null) {
            return false;
        }
        if (other.things() != null && !other.things().equals(this.things())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (things() != null) {
            sb.append("Things: ").append(things()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListThingsResponse> {
        /**
         * <p>
         * The things.
         * </p>
         * 
         * @param things
         *        The things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Collection<ThingAttribute> things);

        /**
         * <p>
         * The things.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setThings(java.util.Collection)} or {@link #withThings(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param things
         *        The things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(ThingAttribute... things);

        /**
         * <p>
         * The token for the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ThingAttribute> things;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsResponse model) {
            setThings(model.things);
            setNextToken(model.nextToken);
        }

        public final Collection<ThingAttribute> getThings() {
            return things;
        }

        @Override
        public final Builder things(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingAttribute... things) {
            if (this.things == null) {
                this.things = new ArrayList<>(things.length);
            }
            for (ThingAttribute e : things) {
                this.things.add(e);
            }
            return this;
        }

        public final void setThings(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
        }

        @SafeVarargs
        public final void setThings(ThingAttribute... things) {
            if (this.things == null) {
                this.things = new ArrayList<>(things.length);
            }
            for (ThingAttribute e : things) {
                this.things.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingsResponse build() {
            return new ListThingsResponse(this);
        }
    }
}
