/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iot.transform.PolicyVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a policy version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PolicyVersion implements StructuredPojo, ToCopyableBuilder<PolicyVersion.Builder, PolicyVersion> {
    private final String versionId;

    private final Boolean isDefaultVersion;

    private final Date createDate;

    private PolicyVersion(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.createDate = builder.createDate;
    }

    /**
     * <p>
     * The policy version ID.
     * </p>
     * 
     * @return The policy version ID.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * Specifies whether the policy version is the default.
     * </p>
     * 
     * @return Specifies whether the policy version is the default.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    /**
     * <p>
     * The date and time the policy was created.
     * </p>
     * 
     * @return The date and time the policy was created.
     */
    public Date createDate() {
        return createDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((isDefaultVersion() == null) ? 0 : isDefaultVersion().hashCode());
        hashCode = 31 * hashCode + ((createDate() == null) ? 0 : createDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersion)) {
            return false;
        }
        PolicyVersion other = (PolicyVersion) obj;
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.isDefaultVersion() == null ^ this.isDefaultVersion() == null) {
            return false;
        }
        if (other.isDefaultVersion() != null && !other.isDefaultVersion().equals(this.isDefaultVersion())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (isDefaultVersion() != null) {
            sb.append("IsDefaultVersion: ").append(isDefaultVersion()).append(",");
        }
        if (createDate() != null) {
            sb.append("CreateDate: ").append(createDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PolicyVersion> {
        /**
         * <p>
         * The policy version ID.
         * </p>
         * 
         * @param versionId
         *        The policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Specifies whether the policy version is the default.
         * </p>
         * 
         * @param isDefaultVersion
         *        Specifies whether the policy version is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);

        /**
         * <p>
         * The date and time the policy was created.
         * </p>
         * 
         * @param createDate
         *        The date and time the policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Date createDate);
    }

    private static final class BuilderImpl implements Builder {
        private String versionId;

        private Boolean isDefaultVersion;

        private Date createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersion model) {
            setVersionId(model.versionId);
            setIsDefaultVersion(model.isDefaultVersion);
            setCreateDate(model.createDate);
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final Date getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
        }

        @Override
        public PolicyVersion build() {
            return new PolicyVersion(this);
        }
    }
}
