/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.S3ActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write data to an Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Action implements StructuredPojo, ToCopyableBuilder<S3Action.Builder, S3Action> {
    private final String roleArn;

    private final String bucketName;

    private final String key;

    private final String cannedAcl;

    private S3Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key.
     * </p>
     * 
     * @return The object key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information,
     * see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
     *         information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
     *         canned ACLs</a>.
     * @see CannedAccessControlList
     */
    public String cannedAcl() {
        return cannedAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((bucketName() == null) ? 0 : bucketName().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((cannedAcl() == null) ? 0 : cannedAcl().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action) obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.bucketName() == null ^ this.bucketName() == null) {
            return false;
        }
        if (other.bucketName() != null && !other.bucketName().equals(this.bucketName())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.cannedAcl() == null ^ this.cannedAcl() == null) {
            return false;
        }
        if (other.cannedAcl() != null && !other.cannedAcl().equals(this.cannedAcl())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (bucketName() != null) {
            sb.append("BucketName: ").append(bucketName()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (cannedAcl() != null) {
            sb.append("CannedAcl: ").append(cannedAcl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3Action> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key.
         * </p>
         * 
         * @param key
         *        The object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
         * canned ACLs</a>.
         * </p>
         * 
         * @param cannedAcl
         *        The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAccessControlList
         */
        Builder cannedAcl(String cannedAcl);

        /**
         * <p>
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
         * canned ACLs</a>.
         * </p>
         * 
         * @param cannedAcl
         *        The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAccessControlList
         */
        Builder cannedAcl(CannedAccessControlList cannedAcl);
    }

    private static final class BuilderImpl implements Builder {
        private String roleArn;

        private String bucketName;

        private String key;

        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            setRoleArn(model.roleArn);
            setBucketName(model.bucketName);
            setKey(model.key);
            setCannedAcl(model.cannedAcl);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getCannedAcl() {
            return cannedAcl;
        }

        @Override
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        public final Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl.toString());
            return this;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        public final void setCannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl.toString());
        }

        @Override
        public S3Action build() {
            return new S3Action(this);
        }
    }
}
